#!/bin/bash

# See https://github.com/lehner/gpt/blob/master/lib/cgpt/update
# Original author Christoph Lehner

# configure warning
WARNING="This file is automatically generated, do not modify!"

# Automatically generate list of exported functions
export LC_ALL=C
(
    echo "// ${WARNING}" 
    sed -n 's/EXPORT(\([^,]*\),.*/EXPORT_FUNCTION(\1)/p' *.cpp | sort
) > exports.h

for f in "$@" ; do
    cat "$f" >> exports.h
done

echo "  Found $(grep -c EXPORT exports.h) exported functions"
echo "================================================================================"
