/**
 * OpenSearch version.
 *
 * @stability stable
 */
export declare class EngineVersion {
    readonly version: string;
    /**
     * AWS Elasticsearch 1.5.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_1_5: EngineVersion;
    /**
     * AWS Elasticsearch 2.3.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_2_3: EngineVersion;
    /**
     * AWS Elasticsearch 5.1.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_5_1: EngineVersion;
    /**
     * AWS Elasticsearch 5.3.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_5_3: EngineVersion;
    /**
     * AWS Elasticsearch 5.5.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_5_5: EngineVersion;
    /**
     * AWS Elasticsearch 5.6.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_5_6: EngineVersion;
    /**
     * AWS Elasticsearch 6.0.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_6_0: EngineVersion;
    /**
     * AWS Elasticsearch 6.2.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_6_2: EngineVersion;
    /**
     * AWS Elasticsearch 6.3.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_6_3: EngineVersion;
    /**
     * AWS Elasticsearch 6.4.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_6_4: EngineVersion;
    /**
     * AWS Elasticsearch 6.5.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_6_5: EngineVersion;
    /**
     * AWS Elasticsearch 6.7.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_6_7: EngineVersion;
    /**
     * AWS Elasticsearch 6.8.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_6_8: EngineVersion;
    /**
     * AWS Elasticsearch 7.1.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_7_1: EngineVersion;
    /**
     * AWS Elasticsearch 7.4.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_7_4: EngineVersion;
    /**
     * AWS Elasticsearch 7.7.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_7_7: EngineVersion;
    /**
     * AWS Elasticsearch 7.8.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_7_8: EngineVersion;
    /**
     * AWS Elasticsearch 7.9.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_7_9: EngineVersion;
    /**
     * AWS Elasticsearch 7.10.
     *
     * @stability stable
     */
    static readonly ELASTICSEARCH_7_10: EngineVersion;
    /**
     * AWS OpenSearch 1.0.
     *
     * @stability stable
     */
    static readonly OPENSEARCH_1_0: EngineVersion;
    /**
     * Custom ElasticSearch version.
     *
     * @param version custom version number.
     * @stability stable
     */
    static elasticsearch(version: string): EngineVersion;
    /**
     * Custom OpenSearch version.
     *
     * @param version custom version number.
     * @stability stable
     */
    static openSearch(version: string): EngineVersion;
    /**
     * @param version engine version identifier
     */
    private constructor();
}
