"""
Clean Documentation generated by nbdev
"""
import re
from pathlib import Path

DOC_ROOT = Path(__file__).parent.parent / "docs"

def fix_sidebar():
    """Fix links in sidebar (module.html instead of /module)"""
    for file in ("sidebar.json", "_data/sidebars/home_sidebar.yml"):
        path = DOC_ROOT / file
        if not path.is_file():
            continue

        content = path.read_text(encoding="utf-8", errors="surrogateescape")
        new_content = re.sub(r"(\w+)\.html", r"/\1", content)
        path.write_text(new_content, encoding="utf-8")
        if new_content != content:
            print(f"Cleaned: documentation links in {path}")

if __name__ == "__main__":
    fix_sidebar()
