# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 9
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isi_sdk_8_2_2.models.snapshot_snapshot import SnapshotSnapshot  # noqa: F401,E501


class SnapshotSnapshotCreateParams(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'alias': 'str',
        'expires': 'int',
        'name': 'str',
        'path': 'str'
    }

    attribute_map = {
        'alias': 'alias',
        'expires': 'expires',
        'name': 'name',
        'path': 'path'
    }

    def __init__(self, alias=None, expires=None, name=None, path=None):  # noqa: E501
        """SnapshotSnapshotCreateParams - a model defined in Swagger"""  # noqa: E501

        self._alias = None
        self._expires = None
        self._name = None
        self._path = None
        self.discriminator = None

        if alias is not None:
            self.alias = alias
        if expires is not None:
            self.expires = expires
        if name is not None:
            self.name = name
        self.path = path

    @property
    def alias(self):
        """Gets the alias of this SnapshotSnapshotCreateParams.  # noqa: E501

        Alias name to create for this snapshot. If null, remove any alias.  # noqa: E501

        :return: The alias of this SnapshotSnapshotCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._alias

    @alias.setter
    def alias(self, alias):
        """Sets the alias of this SnapshotSnapshotCreateParams.

        Alias name to create for this snapshot. If null, remove any alias.  # noqa: E501

        :param alias: The alias of this SnapshotSnapshotCreateParams.  # noqa: E501
        :type: str
        """
        if alias is not None and len(alias) < 0:
            raise ValueError("Invalid value for `alias`, length must be greater than or equal to `0`")  # noqa: E501

        self._alias = alias

    @property
    def expires(self):
        """Gets the expires of this SnapshotSnapshotCreateParams.  # noqa: E501

        The Unix Epoch time the snapshot will expire and be eligible for automatic deletion.  # noqa: E501

        :return: The expires of this SnapshotSnapshotCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._expires

    @expires.setter
    def expires(self, expires):
        """Sets the expires of this SnapshotSnapshotCreateParams.

        The Unix Epoch time the snapshot will expire and be eligible for automatic deletion.  # noqa: E501

        :param expires: The expires of this SnapshotSnapshotCreateParams.  # noqa: E501
        :type: int
        """
        if expires is not None and expires > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `expires`, must be a value less than or equal to `4294967295`")  # noqa: E501

        self._expires = expires

    @property
    def name(self):
        """Gets the name of this SnapshotSnapshotCreateParams.  # noqa: E501

        The user or system supplied snapshot name. This will be null for snapshots pending delete.  # noqa: E501

        :return: The name of this SnapshotSnapshotCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SnapshotSnapshotCreateParams.

        The user or system supplied snapshot name. This will be null for snapshots pending delete.  # noqa: E501

        :param name: The name of this SnapshotSnapshotCreateParams.  # noqa: E501
        :type: str
        """
        if name is not None and len(name) < 0:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `0`")  # noqa: E501

        self._name = name

    @property
    def path(self):
        """Gets the path of this SnapshotSnapshotCreateParams.  # noqa: E501

        The /ifs path snapshotted.  # noqa: E501

        :return: The path of this SnapshotSnapshotCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this SnapshotSnapshotCreateParams.

        The /ifs path snapshotted.  # noqa: E501

        :param path: The path of this SnapshotSnapshotCreateParams.  # noqa: E501
        :type: str
        """
        if path is None:
            raise ValueError("Invalid value for `path`, must not be `None`")  # noqa: E501
        if path is not None and len(path) > 4096:
            raise ValueError("Invalid value for `path`, length must be less than or equal to `4096`")  # noqa: E501
        if path is not None and len(path) < 4:
            raise ValueError("Invalid value for `path`, length must be greater than or equal to `4`")  # noqa: E501
        if path is not None and not re.search('^\/ifs', path):  # noqa: E501
            raise ValueError("Invalid value for `path`, must be a follow pattern or equal to `/^\/ifs/`")  # noqa: E501

        self._path = path

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotSnapshotCreateParams):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
