import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { CfnVirtualService } from './appmesh.generated';
import { IMesh } from './mesh';
import { IVirtualNode } from './virtual-node';
import { IVirtualRouter } from './virtual-router';
/**
 * (experimental) Represents the interface which all VirtualService based classes MUST implement.
 *
 * @experimental
 */
export interface IVirtualService extends cdk.IResource {
    /**
     * (experimental) The name of the VirtualService.
     *
     * @experimental
     * @attribute true
     */
    readonly virtualServiceName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the virtual service.
     *
     * @experimental
     * @attribute true
     */
    readonly virtualServiceArn: string;
    /**
     * (experimental) The Mesh which the VirtualService belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
}
/**
 * (experimental) The properties applied to the VirtualService being defined.
 *
 * @experimental
 */
export interface VirtualServiceProps {
    /**
     * (experimental) The name of the VirtualService.
     *
     * It is recommended this follows the fully-qualified domain name format,
     * such as "my-service.default.svc.cluster.local".
     *
     * @default - A name is automatically generated
     * @experimental
     * @example
     *
     * service.domain.local
     */
    readonly virtualServiceName?: string;
    /**
     * (experimental) The VirtualNode or VirtualRouter which the VirtualService uses as its provider.
     *
     * @experimental
     */
    readonly virtualServiceProvider: VirtualServiceProvider;
}
/**
 * (experimental) VirtualService represents a service inside an AppMesh.
 *
 * It routes traffic either to a Virtual Node or to a Virtual Router.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html
 * @experimental
 */
export declare class VirtualService extends cdk.Resource implements IVirtualService {
    /**
     * (experimental) Import an existing VirtualService given an ARN.
     *
     * @experimental
     */
    static fromVirtualServiceArn(scope: Construct, id: string, virtualServiceArn: string): IVirtualService;
    /**
     * (experimental) Import an existing VirtualService given its attributes.
     *
     * @experimental
     */
    static fromVirtualServiceAttributes(scope: Construct, id: string, attrs: VirtualServiceAttributes): IVirtualService;
    /**
     * (experimental) The name of the VirtualService, it is recommended this follows the fully-qualified domain name format.
     *
     * @experimental
     */
    readonly virtualServiceName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the virtual service.
     *
     * @experimental
     */
    readonly virtualServiceArn: string;
    /**
     * (experimental) The Mesh which the VirtualService belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: VirtualServiceProps);
}
/**
 * (experimental) Interface with properties ncecessary to import a reusable VirtualService.
 *
 * @experimental
 */
export interface VirtualServiceAttributes {
    /**
     * (experimental) The name of the VirtualService, it is recommended this follows the fully-qualified domain name format.
     *
     * @experimental
     */
    readonly virtualServiceName: string;
    /**
     * (experimental) The Mesh which the VirtualService belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
}
/**
 * (experimental) Properties for a VirtualService provider.
 *
 * @experimental
 */
export interface VirtualServiceProviderConfig {
    /**
     * (experimental) Virtual Node based provider.
     *
     * @default - none
     * @experimental
     */
    readonly virtualNodeProvider?: CfnVirtualService.VirtualNodeServiceProviderProperty;
    /**
     * (experimental) Virtual Router based provider.
     *
     * @default - none
     * @experimental
     */
    readonly virtualRouterProvider?: CfnVirtualService.VirtualRouterServiceProviderProperty;
    /**
     * (experimental) Mesh the Provider is using.
     *
     * @default - none
     * @experimental
     */
    readonly mesh: IMesh;
}
/**
 * (experimental) Represents the properties needed to define the provider for a VirtualService.
 *
 * @experimental
 */
export declare abstract class VirtualServiceProvider {
    /**
     * (experimental) Returns a VirtualNode based Provider for a VirtualService.
     *
     * @experimental
     */
    static virtualNode(virtualNode: IVirtualNode): VirtualServiceProvider;
    /**
     * (experimental) Returns a VirtualRouter based Provider for a VirtualService.
     *
     * @experimental
     */
    static virtualRouter(virtualRouter: IVirtualRouter): VirtualServiceProvider;
    /**
     * (experimental) Returns an Empty Provider for a VirtualService.
     *
     * This provides no routing capabilities
     * and should only be used as a placeholder
     *
     * @experimental
     */
    static none(mesh: IMesh): VirtualServiceProvider;
    /**
     * (experimental) Enforces mutual exclusivity for VirtualService provider types.
     *
     * @experimental
     */
    abstract bind(_construct: Construct): VirtualServiceProviderConfig;
}
