"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib/core");
const constructs_1 = require("constructs");
const database_secret_1 = require("./database-secret");
const database_query_1 = require("./private/database-query");
const handler_name_1 = require("./private/database-query-provider/handler-name");
const privileges_1 = require("./private/privileges");
class UserBase extends constructs_1.Construct {
    addTablePrivileges(table, ...actions) {
        if (!this.privileges) {
            this.privileges = new privileges_1.UserTablePrivileges(this, 'TablePrivileges', {
                ...this.databaseProps,
                user: this,
            });
        }
        this.privileges.addPrivileges(table, ...actions);
    }
}
/**
 * A user in a Redshift cluster.
 */
class User extends UserBase {
    /**
     * Specify a Redshift user using credentials that already exist.
     */
    static fromUserAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_redshift_alpha_UserAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromUserAttributes);
            }
            throw error;
        }
        return new class extends UserBase {
            constructor() {
                super(...arguments);
                this.username = attrs.username;
                this.password = attrs.password;
                this.cluster = attrs.cluster;
                this.databaseName = attrs.databaseName;
                this.databaseProps = attrs;
            }
        }(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_redshift_alpha_UserProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, User);
            }
            throw error;
        }
        this.databaseProps = props;
        this.cluster = props.cluster;
        this.databaseName = props.databaseName;
        const username = props.username ?? cdk.Names.uniqueId(this).toLowerCase();
        const secret = new database_secret_1.DatabaseSecret(this, 'Secret', {
            username,
            encryptionKey: props.encryptionKey,
        });
        const attachedSecret = secret.attach(props.cluster);
        this.password = attachedSecret.secretValueFromJson('password');
        this.resource = new database_query_1.DatabaseQuery(this, 'Resource', {
            ...this.databaseProps,
            handler: handler_name_1.HandlerName.User,
            properties: {
                username,
                passwordSecretArn: attachedSecret.secretArn,
            },
        });
        attachedSecret.grantRead(this.resource);
        this.username = this.resource.getAttString('username');
        this.secret = secret;
    }
    /**
     * Apply the given removal policy to this resource
     *
     * The Removal Policy controls what happens to this resource when it stops
     * being managed by CloudFormation, either because you've removed it from the
     * CDK application or because you've made a change that requires the resource
     * to be replaced.
     *
     * The resource can be destroyed (`RemovalPolicy.DESTROY`), or left in your AWS
     * account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).
     *
     * This resource is destroyed by default.
     */
    applyRemovalPolicy(policy) {
        this.resource.applyRemovalPolicy(policy);
    }
}
exports.User = User;
_a = JSII_RTTI_SYMBOL_1;
User[_a] = { fqn: "@aws-cdk/aws-redshift-alpha.User", version: "2.134.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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