import * as iam from 'aws-cdk-lib/aws-iam';
import * as cdk from 'aws-cdk-lib/core';
import { Construct } from 'constructs';
import { DatabaseOptions } from '../database-options';
export interface DatabaseQueryProps<HandlerProps> extends DatabaseOptions {
    readonly handler: string;
    readonly properties: HandlerProps;
    /**
     * The policy to apply when this resource is removed from the application.
     *
     * @default cdk.RemovalPolicy.Destroy
     */
    readonly removalPolicy?: cdk.RemovalPolicy;
}
export declare class DatabaseQuery<HandlerProps> extends Construct implements iam.IGrantable {
    readonly grantPrincipal: iam.IPrincipal;
    readonly ref: string;
    private readonly resource;
    constructor(scope: Construct, id: string, props: DatabaseQueryProps<HandlerProps>);
    applyRemovalPolicy(policy: cdk.RemovalPolicy): void;
    getAtt(attributeName: string): cdk.Reference;
    getAttString(attributeName: string): string;
    private getAdminUser;
}
