"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.executeStatement = void 0;
/* eslint-disable-next-line import/no-extraneous-dependencies */
const client_redshift_data_1 = require("@aws-sdk/client-redshift-data");
const redshiftData = new client_redshift_data_1.RedshiftData({});
async function executeStatement(statement, clusterProps) {
    const executeStatementProps = {
        ClusterIdentifier: clusterProps.clusterName,
        Database: clusterProps.databaseName,
        SecretArn: clusterProps.adminUserArn,
        Sql: statement,
    };
    const executedStatement = await redshiftData.executeStatement(executeStatementProps);
    if (!executedStatement.Id) {
        throw new Error('Service error: Statement execution did not return a statement ID');
    }
    await waitForStatementComplete(executedStatement.Id);
}
exports.executeStatement = executeStatement;
const waitTimeout = 100;
async function waitForStatementComplete(statementId) {
    await new Promise((resolve) => {
        setTimeout(() => resolve(), waitTimeout);
    });
    const statement = await redshiftData.describeStatement({ Id: statementId });
    if (statement.Status !== 'FINISHED' && statement.Status !== 'FAILED' && statement.Status !== 'ABORTED') {
        return waitForStatementComplete(statementId);
    }
    else if (statement.Status === 'FINISHED') {
        return;
    }
    else {
        throw new Error(`Statement status was ${statement.Status}: ${statement.Error}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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