"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClusterParameterGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("aws-cdk-lib/core");
const aws_redshift_1 = require("aws-cdk-lib/aws-redshift");
/**
 * A new cluster or instance parameter group
 */
class ClusterParameterGroupBase extends core_1.Resource {
}
/**
 * A cluster parameter group
 *
 * @resource AWS::Redshift::ClusterParameterGroup
 */
class ClusterParameterGroup extends ClusterParameterGroupBase {
    /**
     * Imports a parameter group
     */
    static fromClusterParameterGroupName(scope, id, clusterParameterGroupName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.clusterParameterGroupName = clusterParameterGroupName;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_redshift_alpha_ClusterParameterGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ClusterParameterGroup);
            }
            throw error;
        }
        this.parameters = props.parameters;
        this.resource = new aws_redshift_1.CfnClusterParameterGroup(this, 'Resource', {
            description: props.description || 'Cluster parameter group for family redshift-1.0',
            parameterGroupFamily: 'redshift-1.0',
            parameters: this.parseParameters(),
        });
        this.clusterParameterGroupName = this.resource.ref;
    }
    parseParameters() {
        return Object.entries(this.parameters).map(([name, value]) => {
            return { parameterName: name, parameterValue: value };
        });
    }
    /**
     * Adds a parameter to the parameter group
     *
     * @param name the parameter name
     * @param value the parameter name
     */
    addParameter(name, value) {
        const existingValue = Object.entries(this.parameters).find(([key, _]) => key === name)?.[1];
        if (existingValue === undefined) {
            this.parameters[name] = value;
            this.resource.parameters = this.parseParameters();
        }
        else if (existingValue !== value) {
            throw new Error(`The parameter group already contains the parameter "${name}", but with a different value (Given: ${value}, Existing: ${existingValue}).`);
        }
    }
}
exports.ClusterParameterGroup = ClusterParameterGroup;
_a = JSII_RTTI_SYMBOL_1;
ClusterParameterGroup[_a] = { fqn: "@aws-cdk/aws-redshift-alpha.ClusterParameterGroup", version: "2.134.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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