# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class VroRemoteItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'id': 'str',
        'vro_server_id': 'str',
        'dunes_id': 'str',
        'type': 'str',
        'selectable': 'bool',
        'can_have_children': 'bool',
        'href': 'str',
        'rel': 'str'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'id': 'id',
        'vro_server_id': 'vroServerId',
        'dunes_id': 'dunesId',
        'type': 'type',
        'selectable': 'selectable',
        'can_have_children': 'canHaveChildren',
        'href': 'href',
        'rel': 'rel'
    }

    def __init__(self, name=None, description=None, id=None, vro_server_id=None, dunes_id=None, type=None, selectable=None, can_have_children=None, href=None, rel=None):
        """
        VroRemoteItem - a model defined in Swagger
        """

        self._name = None
        self._description = None
        self._id = None
        self._vro_server_id = None
        self._dunes_id = None
        self._type = None
        self._selectable = None
        self._can_have_children = None
        self._href = None
        self._rel = None

        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if id is not None:
          self.id = id
        if vro_server_id is not None:
          self.vro_server_id = vro_server_id
        if dunes_id is not None:
          self.dunes_id = dunes_id
        if type is not None:
          self.type = type
        if selectable is not None:
          self.selectable = selectable
        if can_have_children is not None:
          self.can_have_children = can_have_children
        if href is not None:
          self.href = href
        if rel is not None:
          self.rel = rel

    @property
    def name(self):
        """
        Gets the name of this VroRemoteItem.

        :return: The name of this VroRemoteItem.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VroRemoteItem.

        :param name: The name of this VroRemoteItem.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this VroRemoteItem.

        :return: The description of this VroRemoteItem.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this VroRemoteItem.

        :param description: The description of this VroRemoteItem.
        :type: str
        """

        self._description = description

    @property
    def id(self):
        """
        Gets the id of this VroRemoteItem.

        :return: The id of this VroRemoteItem.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VroRemoteItem.

        :param id: The id of this VroRemoteItem.
        :type: str
        """

        self._id = id

    @property
    def vro_server_id(self):
        """
        Gets the vro_server_id of this VroRemoteItem.

        :return: The vro_server_id of this VroRemoteItem.
        :rtype: str
        """
        return self._vro_server_id

    @vro_server_id.setter
    def vro_server_id(self, vro_server_id):
        """
        Sets the vro_server_id of this VroRemoteItem.

        :param vro_server_id: The vro_server_id of this VroRemoteItem.
        :type: str
        """

        self._vro_server_id = vro_server_id

    @property
    def dunes_id(self):
        """
        Gets the dunes_id of this VroRemoteItem.

        :return: The dunes_id of this VroRemoteItem.
        :rtype: str
        """
        return self._dunes_id

    @dunes_id.setter
    def dunes_id(self, dunes_id):
        """
        Sets the dunes_id of this VroRemoteItem.

        :param dunes_id: The dunes_id of this VroRemoteItem.
        :type: str
        """

        self._dunes_id = dunes_id

    @property
    def type(self):
        """
        Gets the type of this VroRemoteItem.

        :return: The type of this VroRemoteItem.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this VroRemoteItem.

        :param type: The type of this VroRemoteItem.
        :type: str
        """

        self._type = type

    @property
    def selectable(self):
        """
        Gets the selectable of this VroRemoteItem.

        :return: The selectable of this VroRemoteItem.
        :rtype: bool
        """
        return self._selectable

    @selectable.setter
    def selectable(self, selectable):
        """
        Sets the selectable of this VroRemoteItem.

        :param selectable: The selectable of this VroRemoteItem.
        :type: bool
        """

        self._selectable = selectable

    @property
    def can_have_children(self):
        """
        Gets the can_have_children of this VroRemoteItem.

        :return: The can_have_children of this VroRemoteItem.
        :rtype: bool
        """
        return self._can_have_children

    @can_have_children.setter
    def can_have_children(self, can_have_children):
        """
        Sets the can_have_children of this VroRemoteItem.

        :param can_have_children: The can_have_children of this VroRemoteItem.
        :type: bool
        """

        self._can_have_children = can_have_children

    @property
    def href(self):
        """
        Gets the href of this VroRemoteItem.

        :return: The href of this VroRemoteItem.
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """
        Sets the href of this VroRemoteItem.

        :param href: The href of this VroRemoteItem.
        :type: str
        """

        self._href = href

    @property
    def rel(self):
        """
        Gets the rel of this VroRemoteItem.

        :return: The rel of this VroRemoteItem.
        :rtype: str
        """
        return self._rel

    @rel.setter
    def rel(self, rel):
        """
        Sets the rel of this VroRemoteItem.

        :param rel: The rel of this VroRemoteItem.
        :type: str
        """

        self._rel = rel

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, VroRemoteItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
