# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class User(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'username': 'str',
        'description': 'str',
        'org_entity_ref': 'EntityReference',
        'fullname': 'str',
        'email': 'str',
        'phone_number': 'str',
        'im': 'str',
        'external': 'bool',
        'name_in_source': 'str',
        'source_entity_ref': 'EntityReference',
        'enabled': 'bool',
        'locked': 'bool',
        'alert_email_prefix': 'str',
        'alert_email': 'str',
        'role_entity_ref': 'EntityReference',
        'role_inherited': 'bool',
        'delay_after_power_on_seconds': 'int',
        'stored_vm_quota': 'int',
        'deployed_vm_quota': 'int',
        'in_sync': 'bool'
    }

    attribute_map = {
        'username': 'username',
        'description': 'description',
        'org_entity_ref': 'orgEntityRef',
        'fullname': 'fullname',
        'email': 'email',
        'phone_number': 'phoneNumber',
        'im': 'im',
        'external': 'external',
        'name_in_source': 'nameInSource',
        'source_entity_ref': 'sourceEntityRef',
        'enabled': 'enabled',
        'locked': 'locked',
        'alert_email_prefix': 'alertEmailPrefix',
        'alert_email': 'alertEmail',
        'role_entity_ref': 'roleEntityRef',
        'role_inherited': 'roleInherited',
        'delay_after_power_on_seconds': 'delayAfterPowerOnSeconds',
        'stored_vm_quota': 'storedVMQuota',
        'deployed_vm_quota': 'deployedVMQuota',
        'in_sync': 'inSync'
    }

    def __init__(self, username=None, description=None, org_entity_ref=None, fullname=None, email=None, phone_number=None, im=None, external=None, name_in_source=None, source_entity_ref=None, enabled=None, locked=None, alert_email_prefix=None, alert_email=None, role_entity_ref=None, role_inherited=None, delay_after_power_on_seconds=None, stored_vm_quota=None, deployed_vm_quota=None, in_sync=None):
        """
        User - a model defined in Swagger
        """

        self._username = None
        self._description = None
        self._org_entity_ref = None
        self._fullname = None
        self._email = None
        self._phone_number = None
        self._im = None
        self._external = None
        self._name_in_source = None
        self._source_entity_ref = None
        self._enabled = None
        self._locked = None
        self._alert_email_prefix = None
        self._alert_email = None
        self._role_entity_ref = None
        self._role_inherited = None
        self._delay_after_power_on_seconds = None
        self._stored_vm_quota = None
        self._deployed_vm_quota = None
        self._in_sync = None

        if username is not None:
          self.username = username
        if description is not None:
          self.description = description
        if org_entity_ref is not None:
          self.org_entity_ref = org_entity_ref
        if fullname is not None:
          self.fullname = fullname
        if email is not None:
          self.email = email
        if phone_number is not None:
          self.phone_number = phone_number
        if im is not None:
          self.im = im
        if external is not None:
          self.external = external
        if name_in_source is not None:
          self.name_in_source = name_in_source
        if source_entity_ref is not None:
          self.source_entity_ref = source_entity_ref
        if enabled is not None:
          self.enabled = enabled
        if locked is not None:
          self.locked = locked
        if alert_email_prefix is not None:
          self.alert_email_prefix = alert_email_prefix
        if alert_email is not None:
          self.alert_email = alert_email
        if role_entity_ref is not None:
          self.role_entity_ref = role_entity_ref
        if role_inherited is not None:
          self.role_inherited = role_inherited
        if delay_after_power_on_seconds is not None:
          self.delay_after_power_on_seconds = delay_after_power_on_seconds
        if stored_vm_quota is not None:
          self.stored_vm_quota = stored_vm_quota
        if deployed_vm_quota is not None:
          self.deployed_vm_quota = deployed_vm_quota
        if in_sync is not None:
          self.in_sync = in_sync

    @property
    def username(self):
        """
        Gets the username of this User.

        :return: The username of this User.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this User.

        :param username: The username of this User.
        :type: str
        """

        self._username = username

    @property
    def description(self):
        """
        Gets the description of this User.

        :return: The description of this User.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this User.

        :param description: The description of this User.
        :type: str
        """

        self._description = description

    @property
    def org_entity_ref(self):
        """
        Gets the org_entity_ref of this User.

        :return: The org_entity_ref of this User.
        :rtype: EntityReference
        """
        return self._org_entity_ref

    @org_entity_ref.setter
    def org_entity_ref(self, org_entity_ref):
        """
        Sets the org_entity_ref of this User.

        :param org_entity_ref: The org_entity_ref of this User.
        :type: EntityReference
        """

        self._org_entity_ref = org_entity_ref

    @property
    def fullname(self):
        """
        Gets the fullname of this User.

        :return: The fullname of this User.
        :rtype: str
        """
        return self._fullname

    @fullname.setter
    def fullname(self, fullname):
        """
        Sets the fullname of this User.

        :param fullname: The fullname of this User.
        :type: str
        """

        self._fullname = fullname

    @property
    def email(self):
        """
        Gets the email of this User.

        :return: The email of this User.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this User.

        :param email: The email of this User.
        :type: str
        """

        self._email = email

    @property
    def phone_number(self):
        """
        Gets the phone_number of this User.

        :return: The phone_number of this User.
        :rtype: str
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number):
        """
        Sets the phone_number of this User.

        :param phone_number: The phone_number of this User.
        :type: str
        """

        self._phone_number = phone_number

    @property
    def im(self):
        """
        Gets the im of this User.

        :return: The im of this User.
        :rtype: str
        """
        return self._im

    @im.setter
    def im(self, im):
        """
        Sets the im of this User.

        :param im: The im of this User.
        :type: str
        """

        self._im = im

    @property
    def external(self):
        """
        Gets the external of this User.

        :return: The external of this User.
        :rtype: bool
        """
        return self._external

    @external.setter
    def external(self, external):
        """
        Sets the external of this User.

        :param external: The external of this User.
        :type: bool
        """

        self._external = external

    @property
    def name_in_source(self):
        """
        Gets the name_in_source of this User.

        :return: The name_in_source of this User.
        :rtype: str
        """
        return self._name_in_source

    @name_in_source.setter
    def name_in_source(self, name_in_source):
        """
        Sets the name_in_source of this User.

        :param name_in_source: The name_in_source of this User.
        :type: str
        """

        self._name_in_source = name_in_source

    @property
    def source_entity_ref(self):
        """
        Gets the source_entity_ref of this User.

        :return: The source_entity_ref of this User.
        :rtype: EntityReference
        """
        return self._source_entity_ref

    @source_entity_ref.setter
    def source_entity_ref(self, source_entity_ref):
        """
        Sets the source_entity_ref of this User.

        :param source_entity_ref: The source_entity_ref of this User.
        :type: EntityReference
        """

        self._source_entity_ref = source_entity_ref

    @property
    def enabled(self):
        """
        Gets the enabled of this User.

        :return: The enabled of this User.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this User.

        :param enabled: The enabled of this User.
        :type: bool
        """

        self._enabled = enabled

    @property
    def locked(self):
        """
        Gets the locked of this User.

        :return: The locked of this User.
        :rtype: bool
        """
        return self._locked

    @locked.setter
    def locked(self, locked):
        """
        Sets the locked of this User.

        :param locked: The locked of this User.
        :type: bool
        """

        self._locked = locked

    @property
    def alert_email_prefix(self):
        """
        Gets the alert_email_prefix of this User.

        :return: The alert_email_prefix of this User.
        :rtype: str
        """
        return self._alert_email_prefix

    @alert_email_prefix.setter
    def alert_email_prefix(self, alert_email_prefix):
        """
        Sets the alert_email_prefix of this User.

        :param alert_email_prefix: The alert_email_prefix of this User.
        :type: str
        """

        self._alert_email_prefix = alert_email_prefix

    @property
    def alert_email(self):
        """
        Gets the alert_email of this User.

        :return: The alert_email of this User.
        :rtype: str
        """
        return self._alert_email

    @alert_email.setter
    def alert_email(self, alert_email):
        """
        Sets the alert_email of this User.

        :param alert_email: The alert_email of this User.
        :type: str
        """

        self._alert_email = alert_email

    @property
    def role_entity_ref(self):
        """
        Gets the role_entity_ref of this User.

        :return: The role_entity_ref of this User.
        :rtype: EntityReference
        """
        return self._role_entity_ref

    @role_entity_ref.setter
    def role_entity_ref(self, role_entity_ref):
        """
        Sets the role_entity_ref of this User.

        :param role_entity_ref: The role_entity_ref of this User.
        :type: EntityReference
        """

        self._role_entity_ref = role_entity_ref

    @property
    def role_inherited(self):
        """
        Gets the role_inherited of this User.

        :return: The role_inherited of this User.
        :rtype: bool
        """
        return self._role_inherited

    @role_inherited.setter
    def role_inherited(self, role_inherited):
        """
        Sets the role_inherited of this User.

        :param role_inherited: The role_inherited of this User.
        :type: bool
        """

        self._role_inherited = role_inherited

    @property
    def delay_after_power_on_seconds(self):
        """
        Gets the delay_after_power_on_seconds of this User.

        :return: The delay_after_power_on_seconds of this User.
        :rtype: int
        """
        return self._delay_after_power_on_seconds

    @delay_after_power_on_seconds.setter
    def delay_after_power_on_seconds(self, delay_after_power_on_seconds):
        """
        Sets the delay_after_power_on_seconds of this User.

        :param delay_after_power_on_seconds: The delay_after_power_on_seconds of this User.
        :type: int
        """

        self._delay_after_power_on_seconds = delay_after_power_on_seconds

    @property
    def stored_vm_quota(self):
        """
        Gets the stored_vm_quota of this User.

        :return: The stored_vm_quota of this User.
        :rtype: int
        """
        return self._stored_vm_quota

    @stored_vm_quota.setter
    def stored_vm_quota(self, stored_vm_quota):
        """
        Sets the stored_vm_quota of this User.

        :param stored_vm_quota: The stored_vm_quota of this User.
        :type: int
        """

        self._stored_vm_quota = stored_vm_quota

    @property
    def deployed_vm_quota(self):
        """
        Gets the deployed_vm_quota of this User.

        :return: The deployed_vm_quota of this User.
        :rtype: int
        """
        return self._deployed_vm_quota

    @deployed_vm_quota.setter
    def deployed_vm_quota(self, deployed_vm_quota):
        """
        Sets the deployed_vm_quota of this User.

        :param deployed_vm_quota: The deployed_vm_quota of this User.
        :type: int
        """

        self._deployed_vm_quota = deployed_vm_quota

    @property
    def in_sync(self):
        """
        Gets the in_sync of this User.

        :return: The in_sync of this User.
        :rtype: bool
        """
        return self._in_sync

    @in_sync.setter
    def in_sync(self, in_sync):
        """
        Sets the in_sync of this User.

        :param in_sync: The in_sync of this User.
        :type: bool
        """

        self._in_sync = in_sync

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, User):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
