# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SupportedConstraints(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'constraint': 'Constraint',
        'mandatory': 'Mandatory',
        'restrict_duplicates': 'RestrictDuplicates',
        'custom_validator': 'CustomValidator',
        'number_range': 'NumberRange',
        'regexp': 'Regexp',
        'number_format': 'NumberFormat'
    }

    attribute_map = {
        'constraint': 'constraint',
        'mandatory': 'mandatory',
        'restrict_duplicates': 'restrictDuplicates',
        'custom_validator': 'customValidator',
        'number_range': 'numberRange',
        'regexp': 'regexp',
        'number_format': 'numberFormat'
    }

    def __init__(self, constraint=None, mandatory=None, restrict_duplicates=None, custom_validator=None, number_range=None, regexp=None, number_format=None):
        """
        SupportedConstraints - a model defined in Swagger
        """

        self._constraint = None
        self._mandatory = None
        self._restrict_duplicates = None
        self._custom_validator = None
        self._number_range = None
        self._regexp = None
        self._number_format = None

        if constraint is not None:
          self.constraint = constraint
        if mandatory is not None:
          self.mandatory = mandatory
        if restrict_duplicates is not None:
          self.restrict_duplicates = restrict_duplicates
        if custom_validator is not None:
          self.custom_validator = custom_validator
        if number_range is not None:
          self.number_range = number_range
        if regexp is not None:
          self.regexp = regexp
        if number_format is not None:
          self.number_format = number_format

    @property
    def constraint(self):
        """
        Gets the constraint of this SupportedConstraints.

        :return: The constraint of this SupportedConstraints.
        :rtype: Constraint
        """
        return self._constraint

    @constraint.setter
    def constraint(self, constraint):
        """
        Sets the constraint of this SupportedConstraints.

        :param constraint: The constraint of this SupportedConstraints.
        :type: Constraint
        """

        self._constraint = constraint

    @property
    def mandatory(self):
        """
        Gets the mandatory of this SupportedConstraints.

        :return: The mandatory of this SupportedConstraints.
        :rtype: Mandatory
        """
        return self._mandatory

    @mandatory.setter
    def mandatory(self, mandatory):
        """
        Sets the mandatory of this SupportedConstraints.

        :param mandatory: The mandatory of this SupportedConstraints.
        :type: Mandatory
        """

        self._mandatory = mandatory

    @property
    def restrict_duplicates(self):
        """
        Gets the restrict_duplicates of this SupportedConstraints.

        :return: The restrict_duplicates of this SupportedConstraints.
        :rtype: RestrictDuplicates
        """
        return self._restrict_duplicates

    @restrict_duplicates.setter
    def restrict_duplicates(self, restrict_duplicates):
        """
        Sets the restrict_duplicates of this SupportedConstraints.

        :param restrict_duplicates: The restrict_duplicates of this SupportedConstraints.
        :type: RestrictDuplicates
        """

        self._restrict_duplicates = restrict_duplicates

    @property
    def custom_validator(self):
        """
        Gets the custom_validator of this SupportedConstraints.

        :return: The custom_validator of this SupportedConstraints.
        :rtype: CustomValidator
        """
        return self._custom_validator

    @custom_validator.setter
    def custom_validator(self, custom_validator):
        """
        Sets the custom_validator of this SupportedConstraints.

        :param custom_validator: The custom_validator of this SupportedConstraints.
        :type: CustomValidator
        """

        self._custom_validator = custom_validator

    @property
    def number_range(self):
        """
        Gets the number_range of this SupportedConstraints.

        :return: The number_range of this SupportedConstraints.
        :rtype: NumberRange
        """
        return self._number_range

    @number_range.setter
    def number_range(self, number_range):
        """
        Sets the number_range of this SupportedConstraints.

        :param number_range: The number_range of this SupportedConstraints.
        :type: NumberRange
        """

        self._number_range = number_range

    @property
    def regexp(self):
        """
        Gets the regexp of this SupportedConstraints.

        :return: The regexp of this SupportedConstraints.
        :rtype: Regexp
        """
        return self._regexp

    @regexp.setter
    def regexp(self, regexp):
        """
        Sets the regexp of this SupportedConstraints.

        :param regexp: The regexp of this SupportedConstraints.
        :type: Regexp
        """

        self._regexp = regexp

    @property
    def number_format(self):
        """
        Gets the number_format of this SupportedConstraints.

        :return: The number_format of this SupportedConstraints.
        :rtype: NumberFormat
        """
        return self._number_format

    @number_format.setter
    def number_format(self, number_format):
        """
        Sets the number_format of this SupportedConstraints.

        :param number_format: The number_format of this SupportedConstraints.
        :type: NumberFormat
        """

        self._number_format = number_format

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SupportedConstraints):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
