# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SmtpServerSpec(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'use_authentication': 'bool',
        'secure_mode': 'str',
        'url': 'Url',
        'ssl_trust_store': 'str',
        'user_name': 'str',
        'password': 'str',
        'description': 'str',
        'name': 'str'
    }

    attribute_map = {
        'use_authentication': 'useAuthentication',
        'secure_mode': 'secureMode',
        'url': 'url',
        'ssl_trust_store': 'sslTrustStore',
        'user_name': 'userName',
        'password': 'password',
        'description': 'description',
        'name': 'name'
    }

    def __init__(self, use_authentication=None, secure_mode=None, url=None, ssl_trust_store=None, user_name=None, password=None, description=None, name=None):
        """
        SmtpServerSpec - a model defined in Swagger
        """

        self._use_authentication = None
        self._secure_mode = None
        self._url = None
        self._ssl_trust_store = None
        self._user_name = None
        self._password = None
        self._description = None
        self._name = None

        if use_authentication is not None:
          self.use_authentication = use_authentication
        if secure_mode is not None:
          self.secure_mode = secure_mode
        if url is not None:
          self.url = url
        if ssl_trust_store is not None:
          self.ssl_trust_store = ssl_trust_store
        if user_name is not None:
          self.user_name = user_name
        if password is not None:
          self.password = password
        if description is not None:
          self.description = description
        if name is not None:
          self.name = name

    @property
    def use_authentication(self):
        """
        Gets the use_authentication of this SmtpServerSpec.
        A flag to indicate if the SMTP requires login authentication. If this flag is set to true, caller must provide user name and password 

        :return: The use_authentication of this SmtpServerSpec.
        :rtype: bool
        """
        return self._use_authentication

    @use_authentication.setter
    def use_authentication(self, use_authentication):
        """
        Sets the use_authentication of this SmtpServerSpec.
        A flag to indicate if the SMTP requires login authentication. If this flag is set to true, caller must provide user name and password 

        :param use_authentication: The use_authentication of this SmtpServerSpec.
        :type: bool
        """

        self._use_authentication = use_authentication

    @property
    def secure_mode(self):
        """
        Gets the secure_mode of this SmtpServerSpec.
        Security mode used to connect to the SMTP server 

        :return: The secure_mode of this SmtpServerSpec.
        :rtype: str
        """
        return self._secure_mode

    @secure_mode.setter
    def secure_mode(self, secure_mode):
        """
        Sets the secure_mode of this SmtpServerSpec.
        Security mode used to connect to the SMTP server 

        :param secure_mode: The secure_mode of this SmtpServerSpec.
        :type: str
        """
        allowed_values = ["NONE", "START_TLS", "SSL"]
        if secure_mode not in allowed_values:
            raise ValueError(
                "Invalid value for `secure_mode` ({0}), must be one of {1}"
                .format(secure_mode, allowed_values)
            )

        self._secure_mode = secure_mode

    @property
    def url(self):
        """
        Gets the url of this SmtpServerSpec.

        :return: The url of this SmtpServerSpec.
        :rtype: Url
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this SmtpServerSpec.

        :param url: The url of this SmtpServerSpec.
        :type: Url
        """

        self._url = url

    @property
    def ssl_trust_store(self):
        """
        Gets the ssl_trust_store of this SmtpServerSpec.
        The custom ssl trust certs if ssl is enabled 

        :return: The ssl_trust_store of this SmtpServerSpec.
        :rtype: str
        """
        return self._ssl_trust_store

    @ssl_trust_store.setter
    def ssl_trust_store(self, ssl_trust_store):
        """
        Sets the ssl_trust_store of this SmtpServerSpec.
        The custom ssl trust certs if ssl is enabled 

        :param ssl_trust_store: The ssl_trust_store of this SmtpServerSpec.
        :type: str
        """

        self._ssl_trust_store = ssl_trust_store

    @property
    def user_name(self):
        """
        Gets the user_name of this SmtpServerSpec.
        Username to login to server 

        :return: The user_name of this SmtpServerSpec.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this SmtpServerSpec.
        Username to login to server 

        :param user_name: The user_name of this SmtpServerSpec.
        :type: str
        """

        self._user_name = user_name

    @property
    def password(self):
        """
        Gets the password of this SmtpServerSpec.
        Password to login to the server 

        :return: The password of this SmtpServerSpec.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this SmtpServerSpec.
        Password to login to the server 

        :param password: The password of this SmtpServerSpec.
        :type: str
        """

        self._password = password

    @property
    def description(self):
        """
        Gets the description of this SmtpServerSpec.
        A human readable description of the entity 

        :return: The description of this SmtpServerSpec.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this SmtpServerSpec.
        A human readable description of the entity 

        :param description: The description of this SmtpServerSpec.
        :type: str
        """

        self._description = description

    @property
    def name(self):
        """
        Gets the name of this SmtpServerSpec.
        A human readable name of the entity

        :return: The name of this SmtpServerSpec.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SmtpServerSpec.
        A human readable name of the entity

        :param name: The name of this SmtpServerSpec.
        :type: str
        """

        self._name = name

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SmtpServerSpec):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
