# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class PvdcComputePolicy(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'pvdc_id': 'str',
        'named_vm_group_references': 'list[EntityReference]',
        'named_vm_groups': 'list[list[EntityReference]]',
        'logical_vm_group_references': 'list[EntityReference]'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'pvdc_id': 'pvdcId',
        'named_vm_group_references': 'namedVmGroupReferences',
        'named_vm_groups': 'namedVmGroups',
        'logical_vm_group_references': 'logicalVmGroupReferences'
    }

    def __init__(self, id=None, name=None, description='', pvdc_id=None, named_vm_group_references=None, named_vm_groups=None, logical_vm_group_references=None):
        """
        PvdcComputePolicy - a model defined in Swagger
        """

        self._id = None
        self._name = None
        self._description = None
        self._pvdc_id = None
        self._named_vm_group_references = None
        self._named_vm_groups = None
        self._logical_vm_group_references = None

        if id is not None:
          self.id = id
        self.name = name
        if description is not None:
          self.description = description
        self.pvdc_id = pvdc_id
        if named_vm_group_references is not None:
          self.named_vm_group_references = named_vm_group_references
        if named_vm_groups is not None:
          self.named_vm_groups = named_vm_groups
        if logical_vm_group_references is not None:
          self.logical_vm_group_references = logical_vm_group_references

    @property
    def id(self):
        """
        Gets the id of this PvdcComputePolicy.
        UUID for pVDC compute policy. This is immutable. 

        :return: The id of this PvdcComputePolicy.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PvdcComputePolicy.
        UUID for pVDC compute policy. This is immutable. 

        :param id: The id of this PvdcComputePolicy.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this PvdcComputePolicy.
        Display name. 

        :return: The name of this PvdcComputePolicy.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PvdcComputePolicy.
        Display name. 

        :param name: The name of this PvdcComputePolicy.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        if name is not None and len(name) > 128:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `128`")
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this PvdcComputePolicy.

        :return: The description of this PvdcComputePolicy.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this PvdcComputePolicy.

        :param description: The description of this PvdcComputePolicy.
        :type: str
        """
        if description is not None and len(description) > 256:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `256`")
        if description is not None and len(description) < 1:
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `1`")

        self._description = description

    @property
    def pvdc_id(self):
        """
        Gets the pvdc_id of this PvdcComputePolicy.
        URN for Provider VDC. 

        :return: The pvdc_id of this PvdcComputePolicy.
        :rtype: str
        """
        return self._pvdc_id

    @pvdc_id.setter
    def pvdc_id(self, pvdc_id):
        """
        Sets the pvdc_id of this PvdcComputePolicy.
        URN for Provider VDC. 

        :param pvdc_id: The pvdc_id of this PvdcComputePolicy.
        :type: str
        """
        if pvdc_id is None:
            raise ValueError("Invalid value for `pvdc_id`, must not be `None`")

        self._pvdc_id = pvdc_id

    @property
    def named_vm_group_references(self):
        """
        Gets the named_vm_group_references of this PvdcComputePolicy.
        This field cannot be updated and is a read-only field in the client after creation. Deprecated in Api 33.0, this property will be removed in future release. 

        :return: The named_vm_group_references of this PvdcComputePolicy.
        :rtype: list[EntityReference]
        """
        return self._named_vm_group_references

    @named_vm_group_references.setter
    def named_vm_group_references(self, named_vm_group_references):
        """
        Sets the named_vm_group_references of this PvdcComputePolicy.
        This field cannot be updated and is a read-only field in the client after creation. Deprecated in Api 33.0, this property will be removed in future release. 

        :param named_vm_group_references: The named_vm_group_references of this PvdcComputePolicy.
        :type: list[EntityReference]
        """

        self._named_vm_group_references = named_vm_group_references

    @property
    def named_vm_groups(self):
        """
        Gets the named_vm_groups of this PvdcComputePolicy.
        List of list of vmGroups grouped together in a meaningful manner. A group of vmGroups would consist of one functionally equal vmGroup picked from each cluster of the pvdc. 

        :return: The named_vm_groups of this PvdcComputePolicy.
        :rtype: list[list[EntityReference]]
        """
        return self._named_vm_groups

    @named_vm_groups.setter
    def named_vm_groups(self, named_vm_groups):
        """
        Sets the named_vm_groups of this PvdcComputePolicy.
        List of list of vmGroups grouped together in a meaningful manner. A group of vmGroups would consist of one functionally equal vmGroup picked from each cluster of the pvdc. 

        :param named_vm_groups: The named_vm_groups of this PvdcComputePolicy.
        :type: list[list[EntityReference]]
        """

        self._named_vm_groups = named_vm_groups

    @property
    def logical_vm_group_references(self):
        """
        Gets the logical_vm_group_references of this PvdcComputePolicy.
        This field cannot be updated and is a read-only field after creation. 

        :return: The logical_vm_group_references of this PvdcComputePolicy.
        :rtype: list[EntityReference]
        """
        return self._logical_vm_group_references

    @logical_vm_group_references.setter
    def logical_vm_group_references(self, logical_vm_group_references):
        """
        Sets the logical_vm_group_references of this PvdcComputePolicy.
        This field cannot be updated and is a read-only field after creation. 

        :param logical_vm_group_references: The logical_vm_group_references of this PvdcComputePolicy.
        :type: list[EntityReference]
        """

        self._logical_vm_group_references = logical_vm_group_references

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PvdcComputePolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
