# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class IkeConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ike_version': 'IkeVersionType',
        'dh_groups': 'list[DhGroupType]',
        'digest_algorithms': 'list[IkeDigestAlgorithmType]',
        'encryption_algorithms': 'list[IkeEncryptionAlgorithmType]',
        'sa_life_time': 'int'
    }

    attribute_map = {
        'ike_version': 'ikeVersion',
        'dh_groups': 'dhGroups',
        'digest_algorithms': 'digestAlgorithms',
        'encryption_algorithms': 'encryptionAlgorithms',
        'sa_life_time': 'saLifeTime'
    }

    def __init__(self, ike_version=None, dh_groups=None, digest_algorithms=None, encryption_algorithms=None, sa_life_time=None):
        """
        IkeConfig - a model defined in Swagger
        """

        self._ike_version = None
        self._dh_groups = None
        self._digest_algorithms = None
        self._encryption_algorithms = None
        self._sa_life_time = None

        self.ike_version = ike_version
        self.dh_groups = dh_groups
        if digest_algorithms is not None:
          self.digest_algorithms = digest_algorithms
        self.encryption_algorithms = encryption_algorithms
        if sa_life_time is not None:
          self.sa_life_time = sa_life_time

    @property
    def ike_version(self):
        """
        Gets the ike_version of this IkeConfig.
        IKE Protocol Version to use. The default is IKE_V2.

        :return: The ike_version of this IkeConfig.
        :rtype: IkeVersionType
        """
        return self._ike_version

    @ike_version.setter
    def ike_version(self, ike_version):
        """
        Sets the ike_version of this IkeConfig.
        IKE Protocol Version to use. The default is IKE_V2.

        :param ike_version: The ike_version of this IkeConfig.
        :type: IkeVersionType
        """
        if ike_version is None:
            raise ValueError("Invalid value for `ike_version`, must not be `None`")

        self._ike_version = ike_version

    @property
    def dh_groups(self):
        """
        Gets the dh_groups of this IkeConfig.
        The list of Diffie-Helman groups to be used is PFS is enabled. Default is GROUP14.

        :return: The dh_groups of this IkeConfig.
        :rtype: list[DhGroupType]
        """
        return self._dh_groups

    @dh_groups.setter
    def dh_groups(self, dh_groups):
        """
        Sets the dh_groups of this IkeConfig.
        The list of Diffie-Helman groups to be used is PFS is enabled. Default is GROUP14.

        :param dh_groups: The dh_groups of this IkeConfig.
        :type: list[DhGroupType]
        """
        if dh_groups is None:
            raise ValueError("Invalid value for `dh_groups`, must not be `None`")

        self._dh_groups = dh_groups

    @property
    def digest_algorithms(self):
        """
        Gets the digest_algorithms of this IkeConfig.
        The list of Digest algorithms for IKE. This is used during IKE negotiation. Default is SHA2_256.

        :return: The digest_algorithms of this IkeConfig.
        :rtype: list[IkeDigestAlgorithmType]
        """
        return self._digest_algorithms

    @digest_algorithms.setter
    def digest_algorithms(self, digest_algorithms):
        """
        Sets the digest_algorithms of this IkeConfig.
        The list of Digest algorithms for IKE. This is used during IKE negotiation. Default is SHA2_256.

        :param digest_algorithms: The digest_algorithms of this IkeConfig.
        :type: list[IkeDigestAlgorithmType]
        """

        self._digest_algorithms = digest_algorithms

    @property
    def encryption_algorithms(self):
        """
        Gets the encryption_algorithms of this IkeConfig.
        The list of Encryption algorithms for IKE. This is used during IKE negotiation. Default is AES_128.

        :return: The encryption_algorithms of this IkeConfig.
        :rtype: list[IkeEncryptionAlgorithmType]
        """
        return self._encryption_algorithms

    @encryption_algorithms.setter
    def encryption_algorithms(self, encryption_algorithms):
        """
        Sets the encryption_algorithms of this IkeConfig.
        The list of Encryption algorithms for IKE. This is used during IKE negotiation. Default is AES_128.

        :param encryption_algorithms: The encryption_algorithms of this IkeConfig.
        :type: list[IkeEncryptionAlgorithmType]
        """
        if encryption_algorithms is None:
            raise ValueError("Invalid value for `encryption_algorithms`, must not be `None`")

        self._encryption_algorithms = encryption_algorithms

    @property
    def sa_life_time(self):
        """
        Gets the sa_life_time of this IkeConfig.
        The Security Association life time in seconds. Default is 86400 seconds (1 day).

        :return: The sa_life_time of this IkeConfig.
        :rtype: int
        """
        return self._sa_life_time

    @sa_life_time.setter
    def sa_life_time(self, sa_life_time):
        """
        Sets the sa_life_time of this IkeConfig.
        The Security Association life time in seconds. Default is 86400 seconds (1 day).

        :param sa_life_time: The sa_life_time of this IkeConfig.
        :type: int
        """
        if sa_life_time is not None and sa_life_time > 31536000:
            raise ValueError("Invalid value for `sa_life_time`, must be a value less than or equal to `31536000`")
        if sa_life_time is not None and sa_life_time < 21600:
            raise ValueError("Invalid value for `sa_life_time`, must be a value greater than or equal to `21600`")

        self._sa_life_time = sa_life_time

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, IkeConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
