# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeNatRule(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'enabled': 'bool',
        'rule_type': 'NatRuleType',
        'application_port_profile': 'EntityReference',
        'external_addresses': 'str',
        'internal_addresses': 'str',
        'internal_port': 'str',
        'logging': 'bool',
        'system_rule': 'bool',
        'version': 'ObjectVersion'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'enabled': 'enabled',
        'rule_type': 'ruleType',
        'application_port_profile': 'applicationPortProfile',
        'external_addresses': 'externalAddresses',
        'internal_addresses': 'internalAddresses',
        'internal_port': 'internalPort',
        'logging': 'logging',
        'system_rule': 'systemRule',
        'version': 'version'
    }

    def __init__(self, id=None, name=None, description=None, enabled=True, rule_type=None, application_port_profile=None, external_addresses=None, internal_addresses=None, internal_port=None, logging=False, system_rule=False, version=None):
        """
        EdgeNatRule - a model defined in Swagger
        """

        self._id = None
        self._name = None
        self._description = None
        self._enabled = None
        self._rule_type = None
        self._application_port_profile = None
        self._external_addresses = None
        self._internal_addresses = None
        self._internal_port = None
        self._logging = None
        self._system_rule = None
        self._version = None

        if id is not None:
          self.id = id
        self.name = name
        if description is not None:
          self.description = description
        if enabled is not None:
          self.enabled = enabled
        self.rule_type = rule_type
        if application_port_profile is not None:
          self.application_port_profile = application_port_profile
        self.external_addresses = external_addresses
        self.internal_addresses = internal_addresses
        if internal_port is not None:
          self.internal_port = internal_port
        if logging is not None:
          self.logging = logging
        if system_rule is not None:
          self.system_rule = system_rule
        if version is not None:
          self.version = version

    @property
    def id(self):
        """
        Gets the id of this EdgeNatRule.
        The unique id of the NAT Rule. This must be supplied when updating a given NAT Rule. On creation, an unique id is generated for the NAT Rule. 

        :return: The id of this EdgeNatRule.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EdgeNatRule.
        The unique id of the NAT Rule. This must be supplied when updating a given NAT Rule. On creation, an unique id is generated for the NAT Rule. 

        :param id: The id of this EdgeNatRule.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this EdgeNatRule.
        User friendly name for the NAT Rule. Name must be provided.

        :return: The name of this EdgeNatRule.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EdgeNatRule.
        User friendly name for the NAT Rule. Name must be provided.

        :param name: The name of this EdgeNatRule.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this EdgeNatRule.

        :return: The description of this EdgeNatRule.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this EdgeNatRule.

        :param description: The description of this EdgeNatRule.
        :type: str
        """

        self._description = description

    @property
    def enabled(self):
        """
        Gets the enabled of this EdgeNatRule.
        A flag indicating whether the individual nat rule is enabled or not. The default is true.

        :return: The enabled of this EdgeNatRule.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this EdgeNatRule.
        A flag indicating whether the individual nat rule is enabled or not. The default is true.

        :param enabled: The enabled of this EdgeNatRule.
        :type: bool
        """

        self._enabled = enabled

    @property
    def rule_type(self):
        """
        Gets the rule_type of this EdgeNatRule.
        Represents the type of NAT Rule. SNAT translates an internal IP to an external ip and is used for outbound traffic. DNAT translates the external IP to an internal IP and is used for inbound traffic. 

        :return: The rule_type of this EdgeNatRule.
        :rtype: NatRuleType
        """
        return self._rule_type

    @rule_type.setter
    def rule_type(self, rule_type):
        """
        Sets the rule_type of this EdgeNatRule.
        Represents the type of NAT Rule. SNAT translates an internal IP to an external ip and is used for outbound traffic. DNAT translates the external IP to an internal IP and is used for inbound traffic. 

        :param rule_type: The rule_type of this EdgeNatRule.
        :type: NatRuleType
        """
        if rule_type is None:
            raise ValueError("Invalid value for `rule_type`, must not be `None`")

        self._rule_type = rule_type

    @property
    def application_port_profile(self):
        """
        Gets the application_port_profile of this EdgeNatRule.
        Represents the application ports on which the NAT Rule will be applied. An application port profile id in the form of URN format must be provided. If not provided then the port will be considered as \"ANY\". 

        :return: The application_port_profile of this EdgeNatRule.
        :rtype: EntityReference
        """
        return self._application_port_profile

    @application_port_profile.setter
    def application_port_profile(self, application_port_profile):
        """
        Sets the application_port_profile of this EdgeNatRule.
        Represents the application ports on which the NAT Rule will be applied. An application port profile id in the form of URN format must be provided. If not provided then the port will be considered as \"ANY\". 

        :param application_port_profile: The application_port_profile of this EdgeNatRule.
        :type: EntityReference
        """

        self._application_port_profile = application_port_profile

    @property
    def external_addresses(self):
        """
        Gets the external_addresses of this EdgeNatRule.
        The external addresses for the NAT Rule. This must be supplied as a single ip or Network CIDR. For a DNAT rule, this is the external facing IP Address for incoming traffic. For an SNAT rule, this is the external facing IP Address for outgoing traffic. These ips are typically allocated/suballocated IP Addresses on the Edge Gateway. 

        :return: The external_addresses of this EdgeNatRule.
        :rtype: str
        """
        return self._external_addresses

    @external_addresses.setter
    def external_addresses(self, external_addresses):
        """
        Sets the external_addresses of this EdgeNatRule.
        The external addresses for the NAT Rule. This must be supplied as a single ip or Network CIDR. For a DNAT rule, this is the external facing IP Address for incoming traffic. For an SNAT rule, this is the external facing IP Address for outgoing traffic. These ips are typically allocated/suballocated IP Addresses on the Edge Gateway. 

        :param external_addresses: The external_addresses of this EdgeNatRule.
        :type: str
        """
        if external_addresses is None:
            raise ValueError("Invalid value for `external_addresses`, must not be `None`")

        self._external_addresses = external_addresses

    @property
    def internal_addresses(self):
        """
        Gets the internal_addresses of this EdgeNatRule.
        The internal addresses for the NAT Rule. This must be supplied as a single ip or Network CIDR. For a DNAT rule, this is the internal IP Address for incoming traffic. For an SNAT rule, this is the internal IP Address for outgoing traffic. These ips are typically the Private IPs that are allocated to workloads. 

        :return: The internal_addresses of this EdgeNatRule.
        :rtype: str
        """
        return self._internal_addresses

    @internal_addresses.setter
    def internal_addresses(self, internal_addresses):
        """
        Sets the internal_addresses of this EdgeNatRule.
        The internal addresses for the NAT Rule. This must be supplied as a single ip or Network CIDR. For a DNAT rule, this is the internal IP Address for incoming traffic. For an SNAT rule, this is the internal IP Address for outgoing traffic. These ips are typically the Private IPs that are allocated to workloads. 

        :param internal_addresses: The internal_addresses of this EdgeNatRule.
        :type: str
        """
        if internal_addresses is None:
            raise ValueError("Invalid value for `internal_addresses`, must not be `None`")

        self._internal_addresses = internal_addresses

    @property
    def internal_port(self):
        """
        Gets the internal_port of this EdgeNatRule.
        Port number or port range for incoming network traffic. If Any Traffic is selected for the Service, the default internal port is \"ANY\". 

        :return: The internal_port of this EdgeNatRule.
        :rtype: str
        """
        return self._internal_port

    @internal_port.setter
    def internal_port(self, internal_port):
        """
        Sets the internal_port of this EdgeNatRule.
        Port number or port range for incoming network traffic. If Any Traffic is selected for the Service, the default internal port is \"ANY\". 

        :param internal_port: The internal_port of this EdgeNatRule.
        :type: str
        """

        self._internal_port = internal_port

    @property
    def logging(self):
        """
        Gets the logging of this EdgeNatRule.
        A flag indicating whether logging for the individual nat rule is enabled or not. The default is false.

        :return: The logging of this EdgeNatRule.
        :rtype: bool
        """
        return self._logging

    @logging.setter
    def logging(self, logging):
        """
        Sets the logging of this EdgeNatRule.
        A flag indicating whether logging for the individual nat rule is enabled or not. The default is false.

        :param logging: The logging of this EdgeNatRule.
        :type: bool
        """

        self._logging = logging

    @property
    def system_rule(self):
        """
        Gets the system_rule of this EdgeNatRule.
        A flag indicating whether this NAT rule is managed by the system. This is not user editable

        :return: The system_rule of this EdgeNatRule.
        :rtype: bool
        """
        return self._system_rule

    @system_rule.setter
    def system_rule(self, system_rule):
        """
        Sets the system_rule of this EdgeNatRule.
        A flag indicating whether this NAT rule is managed by the system. This is not user editable

        :param system_rule: The system_rule of this EdgeNatRule.
        :type: bool
        """

        self._system_rule = system_rule

    @property
    def version(self):
        """
        Gets the version of this EdgeNatRule.

        :return: The version of this EdgeNatRule.
        :rtype: ObjectVersion
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this EdgeNatRule.

        :param version: The version of this EdgeNatRule.
        :type: ObjectVersion
        """

        self._version = version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeNatRule):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
