# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeGateway(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'status': 'NetworkingObjectStatusType',
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'edge_gateway_uplinks': 'list[EdgeGatewayUplink]',
        'distributed_routing_enabled': 'bool',
        'org_vdc_network_count': 'int',
        'gateway_backing': 'EdgeGatewayBacking',
        'org_vdc': 'EntityReference',
        'org_ref': 'EntityReference',
        'service_network_definition': 'str'
    }

    attribute_map = {
        'status': 'status',
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'edge_gateway_uplinks': 'edgeGatewayUplinks',
        'distributed_routing_enabled': 'distributedRoutingEnabled',
        'org_vdc_network_count': 'orgVdcNetworkCount',
        'gateway_backing': 'gatewayBacking',
        'org_vdc': 'orgVdc',
        'org_ref': 'orgRef',
        'service_network_definition': 'serviceNetworkDefinition'
    }

    def __init__(self, status=None, id=None, name=None, description=None, edge_gateway_uplinks=None, distributed_routing_enabled=False, org_vdc_network_count=None, gateway_backing=None, org_vdc=None, org_ref=None, service_network_definition=None):
        """
        EdgeGateway - a model defined in Swagger
        """

        self._status = None
        self._id = None
        self._name = None
        self._description = None
        self._edge_gateway_uplinks = None
        self._distributed_routing_enabled = None
        self._org_vdc_network_count = None
        self._gateway_backing = None
        self._org_vdc = None
        self._org_ref = None
        self._service_network_definition = None

        if status is not None:
          self.status = status
        if id is not None:
          self.id = id
        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if edge_gateway_uplinks is not None:
          self.edge_gateway_uplinks = edge_gateway_uplinks
        if distributed_routing_enabled is not None:
          self.distributed_routing_enabled = distributed_routing_enabled
        if org_vdc_network_count is not None:
          self.org_vdc_network_count = org_vdc_network_count
        if gateway_backing is not None:
          self.gateway_backing = gateway_backing
        if org_vdc is not None:
          self.org_vdc = org_vdc
        if org_ref is not None:
          self.org_ref = org_ref
        if service_network_definition is not None:
          self.service_network_definition = service_network_definition

    @property
    def status(self):
        """
        Gets the status of this EdgeGateway.
        Represents current status of the networking object. 

        :return: The status of this EdgeGateway.
        :rtype: NetworkingObjectStatusType
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this EdgeGateway.
        Represents current status of the networking object. 

        :param status: The status of this EdgeGateway.
        :type: NetworkingObjectStatusType
        """

        self._status = status

    @property
    def id(self):
        """
        Gets the id of this EdgeGateway.
        The unique identifier of the edge gateway.

        :return: The id of this EdgeGateway.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EdgeGateway.
        The unique identifier of the edge gateway.

        :param id: The id of this EdgeGateway.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this EdgeGateway.
        The name of the edge gateway.

        :return: The name of this EdgeGateway.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EdgeGateway.
        The name of the edge gateway.

        :param name: The name of this EdgeGateway.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this EdgeGateway.
        The description of the edge gateway(optional).

        :return: The description of this EdgeGateway.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this EdgeGateway.
        The description of the edge gateway(optional).

        :param description: The description of this EdgeGateway.
        :type: str
        """

        self._description = description

    @property
    def edge_gateway_uplinks(self):
        """
        Gets the edge_gateway_uplinks of this EdgeGateway.
        The uplink connections for the edge gateway.

        :return: The edge_gateway_uplinks of this EdgeGateway.
        :rtype: list[EdgeGatewayUplink]
        """
        return self._edge_gateway_uplinks

    @edge_gateway_uplinks.setter
    def edge_gateway_uplinks(self, edge_gateway_uplinks):
        """
        Sets the edge_gateway_uplinks of this EdgeGateway.
        The uplink connections for the edge gateway.

        :param edge_gateway_uplinks: The edge_gateway_uplinks of this EdgeGateway.
        :type: list[EdgeGatewayUplink]
        """

        self._edge_gateway_uplinks = edge_gateway_uplinks

    @property
    def distributed_routing_enabled(self):
        """
        Gets the distributed_routing_enabled of this EdgeGateway.
        A flag indicating whether distributed routing is enabled or not. The default is false.

        :return: The distributed_routing_enabled of this EdgeGateway.
        :rtype: bool
        """
        return self._distributed_routing_enabled

    @distributed_routing_enabled.setter
    def distributed_routing_enabled(self, distributed_routing_enabled):
        """
        Sets the distributed_routing_enabled of this EdgeGateway.
        A flag indicating whether distributed routing is enabled or not. The default is false.

        :param distributed_routing_enabled: The distributed_routing_enabled of this EdgeGateway.
        :type: bool
        """

        self._distributed_routing_enabled = distributed_routing_enabled

    @property
    def org_vdc_network_count(self):
        """
        Gets the org_vdc_network_count of this EdgeGateway.
        The number of Org vDC networks connected to the gateway.

        :return: The org_vdc_network_count of this EdgeGateway.
        :rtype: int
        """
        return self._org_vdc_network_count

    @org_vdc_network_count.setter
    def org_vdc_network_count(self, org_vdc_network_count):
        """
        Sets the org_vdc_network_count of this EdgeGateway.
        The number of Org vDC networks connected to the gateway.

        :param org_vdc_network_count: The org_vdc_network_count of this EdgeGateway.
        :type: int
        """

        self._org_vdc_network_count = org_vdc_network_count

    @property
    def gateway_backing(self):
        """
        Gets the gateway_backing of this EdgeGateway.
        The backing details of the edge gateway; only required if importing an NSX-T router.

        :return: The gateway_backing of this EdgeGateway.
        :rtype: EdgeGatewayBacking
        """
        return self._gateway_backing

    @gateway_backing.setter
    def gateway_backing(self, gateway_backing):
        """
        Sets the gateway_backing of this EdgeGateway.
        The backing details of the edge gateway; only required if importing an NSX-T router.

        :param gateway_backing: The gateway_backing of this EdgeGateway.
        :type: EdgeGatewayBacking
        """

        self._gateway_backing = gateway_backing

    @property
    def org_vdc(self):
        """
        Gets the org_vdc of this EdgeGateway.
        The organization vDC which the gateway belongs to.

        :return: The org_vdc of this EdgeGateway.
        :rtype: EntityReference
        """
        return self._org_vdc

    @org_vdc.setter
    def org_vdc(self, org_vdc):
        """
        Sets the org_vdc of this EdgeGateway.
        The organization vDC which the gateway belongs to.

        :param org_vdc: The org_vdc of this EdgeGateway.
        :type: EntityReference
        """

        self._org_vdc = org_vdc

    @property
    def org_ref(self):
        """
        Gets the org_ref of this EdgeGateway.
        The organization to which the gateway belongs.

        :return: The org_ref of this EdgeGateway.
        :rtype: EntityReference
        """
        return self._org_ref

    @org_ref.setter
    def org_ref(self, org_ref):
        """
        Sets the org_ref of this EdgeGateway.
        The organization to which the gateway belongs.

        :param org_ref: The org_ref of this EdgeGateway.
        :type: EntityReference
        """

        self._org_ref = org_ref

    @property
    def service_network_definition(self):
        """
        Gets the service_network_definition of this EdgeGateway.
        The network definition in CDIR form that DNS and DHCP service on an NSX-T edge will run on. The subnet prefix length must be 27. This property applies to creating or importing an NSX-T Edge. This is not supported for VMC. If nothing is set, the default is 192.168.255.225/27.  The DHCP listener IP network is on 192.168.255.225/30. The DNS listener IP network is on 192.168.255.228/32.  This field cannot be updated. 

        :return: The service_network_definition of this EdgeGateway.
        :rtype: str
        """
        return self._service_network_definition

    @service_network_definition.setter
    def service_network_definition(self, service_network_definition):
        """
        Sets the service_network_definition of this EdgeGateway.
        The network definition in CDIR form that DNS and DHCP service on an NSX-T edge will run on. The subnet prefix length must be 27. This property applies to creating or importing an NSX-T Edge. This is not supported for VMC. If nothing is set, the default is 192.168.255.225/27.  The DHCP listener IP network is on 192.168.255.225/30. The DNS listener IP network is on 192.168.255.228/32.  This field cannot be updated. 

        :param service_network_definition: The service_network_definition of this EdgeGateway.
        :type: str
        """

        self._service_network_definition = service_network_definition

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeGateway):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
