# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeFirewallRules(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'status': 'NetworkingObjectStatusType',
        'system_rules': 'list[EdgeFirewallRule]',
        'user_defined_rules': 'list[EdgeFirewallRule]',
        'default_rules': 'list[EdgeFirewallRule]'
    }

    attribute_map = {
        'status': 'status',
        'system_rules': 'systemRules',
        'user_defined_rules': 'userDefinedRules',
        'default_rules': 'defaultRules'
    }

    def __init__(self, status=None, system_rules=None, user_defined_rules=None, default_rules=None):
        """
        EdgeFirewallRules - a model defined in Swagger
        """

        self._status = None
        self._system_rules = None
        self._user_defined_rules = None
        self._default_rules = None

        if status is not None:
          self.status = status
        if system_rules is not None:
          self.system_rules = system_rules
        if user_defined_rules is not None:
          self.user_defined_rules = user_defined_rules
        if default_rules is not None:
          self.default_rules = default_rules

    @property
    def status(self):
        """
        Gets the status of this EdgeFirewallRules.
        Represents current status of the networking object. 

        :return: The status of this EdgeFirewallRules.
        :rtype: NetworkingObjectStatusType
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this EdgeFirewallRules.
        Represents current status of the networking object. 

        :param status: The status of this EdgeFirewallRules.
        :type: NetworkingObjectStatusType
        """

        self._status = status

    @property
    def system_rules(self):
        """
        Gets the system_rules of this EdgeFirewallRules.
        The ordered list of system defined edge firewall rules. System rules are applied before user defined rules in the order in which they are returned. 

        :return: The system_rules of this EdgeFirewallRules.
        :rtype: list[EdgeFirewallRule]
        """
        return self._system_rules

    @system_rules.setter
    def system_rules(self, system_rules):
        """
        Sets the system_rules of this EdgeFirewallRules.
        The ordered list of system defined edge firewall rules. System rules are applied before user defined rules in the order in which they are returned. 

        :param system_rules: The system_rules of this EdgeFirewallRules.
        :type: list[EdgeFirewallRule]
        """

        self._system_rules = system_rules

    @property
    def user_defined_rules(self):
        """
        Gets the user_defined_rules of this EdgeFirewallRules.
        The ordered list of user defined edge firewall rules. Users are allowed to add/modify/delete rules only to this list. 

        :return: The user_defined_rules of this EdgeFirewallRules.
        :rtype: list[EdgeFirewallRule]
        """
        return self._user_defined_rules

    @user_defined_rules.setter
    def user_defined_rules(self, user_defined_rules):
        """
        Sets the user_defined_rules of this EdgeFirewallRules.
        The ordered list of user defined edge firewall rules. Users are allowed to add/modify/delete rules only to this list. 

        :param user_defined_rules: The user_defined_rules of this EdgeFirewallRules.
        :type: list[EdgeFirewallRule]
        """

        self._user_defined_rules = user_defined_rules

    @property
    def default_rules(self):
        """
        Gets the default_rules of this EdgeFirewallRules.
        The ordered list of default edge firewall rules. Default rules are applied after the user defined rules in the order in which they are returned. 

        :return: The default_rules of this EdgeFirewallRules.
        :rtype: list[EdgeFirewallRule]
        """
        return self._default_rules

    @default_rules.setter
    def default_rules(self, default_rules):
        """
        Sets the default_rules of this EdgeFirewallRules.
        The ordered list of default edge firewall rules. Default rules are applied after the user defined rules in the order in which they are returned. 

        :param default_rules: The default_rules of this EdgeFirewallRules.
        :type: list[EdgeFirewallRule]
        """

        self._default_rules = default_rules

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeFirewallRules):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
