# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

# import models into model package
from .accessible_location import AccessibleLocation
from .allocated_ip_address import AllocatedIpAddress
from .allocated_ip_address_allocation_type import AllocatedIpAddressAllocationType
from .application_port_list import ApplicationPortList
from .application_port_profile_scope_type import ApplicationPortProfileScopeType
from .application_ports_protocol_type import ApplicationPortsProtocolType
from .association import Association
from .audit_trail_event import AuditTrailEvent
from .available_ip_pool_subnet import AvailableIpPoolSubnet
from .available_ip_pool_subnets import AvailableIpPoolSubnets
from .backing_network_type import BackingNetworkType
from .backing_ref import BackingRef
from .capability import Capability
from .capability_category import CapabilityCategory
from .capability_value_type import CapabilityValueType
from .cell import Cell
from .common_nsx_t_router_fields import CommonNsxTRouterFields
from .connector_initiation_mode import ConnectorInitiationMode
from .constraint import Constraint
from .create_custom_entity_type_action import CreateCustomEntityTypeAction
from .custom_entities import CustomEntities
from .custom_entity import CustomEntity
from .custom_entity_type import CustomEntityType
from .custom_entity_type_action import CustomEntityTypeAction
from .custom_entity_type_actions import CustomEntityTypeActions
from .decorator import Decorator
from .df_policy_type import DfPolicyType
from .dh_group_type import DhGroupType
from .distributed_port_group import DistributedPortGroup
from .dpd_config import DpdConfig
from .dv_switch import DvSwitch
from .edge_cluster import EdgeCluster
from .edge_dns_config import EdgeDnsConfig
from .edge_firewall_rule import EdgeFirewallRule
from .edge_gateway_backing import EdgeGatewayBacking
from .edge_gateway_subnets import EdgeGatewaySubnets
from .edge_gateway_type import EdgeGatewayType
from .edge_gateway_uplink import EdgeGatewayUplink
from .edge_ip_sec_vpn_tunnel import EdgeIpSecVpnTunnel
from .edge_ip_sec_vpn_tunnel_connection_properties import EdgeIpSecVpnTunnelConnectionProperties
from .edge_ip_sec_vpn_tunnel_statistics import EdgeIpSecVpnTunnelStatistics
from .edge_ip_sec_vpn_tunnel_status import EdgeIpSecVpnTunnelStatus
from .edge_nat_rule import EdgeNatRule
from .egress_point import EgressPoint
from .egress_point_reference import EgressPointReference
from .egress_points import EgressPoints
from .email_settings import EmailSettings
from .entity_reference import EntityReference
from .error import Error
from .execution_context import ExecutionContext
from .execution_state import ExecutionState
from .execution_summary import ExecutionSummary
from .extension_point import ExtensionPoint
from .extension_point_summary import ExtensionPointSummary
from .external_network_backing import ExternalNetworkBacking
from .external_network_backing_type import ExternalNetworkBackingType
from .external_network_backings import ExternalNetworkBackings
from .firewall_group_scope import FirewallGroupScope
from .firewall_rule_action import FirewallRuleAction
from .firewall_rule_direction import FirewallRuleDirection
from .firewall_rule_ip_protocol import FirewallRuleIpProtocol
from .gateway_used_ip_address import GatewayUsedIpAddress
from .gateway_used_ip_address_category import GatewayUsedIpAddressCategory
from .hardware_versions import HardwareVersions
from .ike_config import IkeConfig
from .ike_digest_algorithm_type import IkeDigestAlgorithmType
from .ike_encryption_algorithm_type import IkeEncryptionAlgorithmType
from .ike_service_status import IkeServiceStatus
from .ike_status import IkeStatus
from .ike_version_type import IkeVersionType
from .ip_range import IpRange
from .ip_ranges import IpRanges
from .ldap_connection_test_result import LdapConnectionTestResult
from .ldap_group_attributes_type import LdapGroupAttributesType
from .ldap_settings import LdapSettings
from .ldap_settings_test_result import LdapSettingsTestResult
from .ldap_test_result import LdapTestResult
from .ldap_user_attributes_type import LdapUserAttributesType
from .link import Link
from .local_endpoint import LocalEndpoint
from .logical_vm_group import LogicalVmGroup
from .nat_rule_type import NatRuleType
from .network import Network
from .network_pool_backing import NetworkPoolBacking
from .network_pool_backing_type import NetworkPoolBackingType
from .network_provider_context import NetworkProviderContext
from .networking_object_status import NetworkingObjectStatus
from .networking_object_status_type import NetworkingObjectStatusType
from .nsx_t_transport_zone import NsxTTransportZone
from .nsx_t_transport_zone_type import NsxTTransportZoneType
from .nsx_t_transport_zones import NsxTTransportZones
from .nsx_v_transport_zone import NsxVTransportZone
from .nsx_v_transport_zone_type import NsxVTransportZoneType
from .nsx_v_transport_zones import NsxVTransportZones
from .nsxt_dns_forwarder_zone_config import NsxtDnsForwarderZoneConfig
from .object_version import ObjectVersion
from .org_vdc_network_status import OrgVdcNetworkStatus
from .overall_status import OverallStatus
from .page import Page
from .parameter import Parameter
from .parameter_types import ParameterTypes
from .participating_vdc_reference import ParticipatingVdcReference
from .port_group import PortGroup
from .preference import Preference
from .preference_definition import PreferenceDefinition
from .presentation import Presentation
from .presentation_element import PresentationElement
from .presentation_execution import PresentationExecution
from .presentation_executions_list import PresentationExecutionsList
from .presentation_message_info import PresentationMessageInfo
from .provider_vdc import ProviderVdc
from .proxy import Proxy
from .pvdc_compute_policy import PvdcComputePolicy
from .relations import Relations
from .remote_endpoint import RemoteEndpoint
from .resource_pool import ResourcePool
from .right import Right
from .rights_category_node import RightsCategoryNode
from .rights_count import RightsCount
from .rights_mapping import RightsMapping
from .router_component_health import RouterComponentHealth
from .router_component_status import RouterComponentStatus
from .router_connection import RouterConnection
from .router_dns_config import RouterDnsConfig
from .router_health_report import RouterHealthReport
from .sddc import Sddc
from .sddc_endpoint import SddcEndpoint
from .sddc_proxy import SddcProxy
from .sddc_stat import SddcStat
from .sddc_stats import SddcStats
from .service import Service
from .service_app import ServiceApp
from .service_app_scope import ServiceAppScope
from .service_item import ServiceItem
from .session import Session
from .smtp_server_spec import SmtpServerSpec
from .storage_profile import StorageProfile
from .subnet import Subnet
from .subnets import Subnets
from .supported_constraints import SupportedConstraints
from .supported_decorators import SupportedDecorators
from .supported_presentation_elements import SupportedPresentationElements
from .test_email_request import TestEmailRequest
from .tier0_routers import Tier0Routers
from .token import Token
from .tunnel_config import TunnelConfig
from .tunnel_digest_algorithm_type import TunnelDigestAlgorithmType
from .tunnel_encryption_algorithm_type import TunnelEncryptionAlgorithmType
from .tunnel_security_type import TunnelSecurityType
from .tunnel_status import TunnelStatus
from .ui_branding import UiBranding
from .ui_branding_menu_item import UiBrandingMenuItem
from .ui_plugin_metadata import UiPluginMetadata
from .ui_theme import UiTheme
from .universal_egress_routes import UniversalEgressRoutes
from .universal_route import UniversalRoute
from .universal_router import UniversalRouter
from .universal_router_dhcp_config import UniversalRouterDhcpConfig
from .universal_router_dhcp_server import UniversalRouterDhcpServer
from .universal_routers import UniversalRouters
from .universal_routes import UniversalRoutes
from .universal_routing_status import UniversalRoutingStatus
from .upload_metadata_response import UploadMetadataResponse
from .upload_spec import UploadSpec
from .url import Url
from .used_ip_address import UsedIpAddress
from .used_ip_address_allocation_type import UsedIpAddressAllocationType
from .user import User
from .user_group import UserGroup
from .vro_service_info import VROServiceInfo
from .vdc_compute_policy import VdcComputePolicy
from .vdc_group import VdcGroup
from .vdc_group_entity_status import VdcGroupEntityStatus
from .vdc_network_connection_type import VdcNetworkConnectionType
from .vdc_network_dhcp_config import VdcNetworkDhcpConfig
from .vdc_network_dhcp_pool import VdcNetworkDhcpPool
from .vdc_network_fence_type import VdcNetworkFenceType
from .vdc_network_profile import VdcNetworkProfile
from .vlan_id_range import VlanIdRange
from .vlan_id_ranges import VlanIdRanges
from .vmc_sddc import VmcSddc
from .vro_remote_inventory_item import VroRemoteInventoryItem
from .vro_remote_item import VroRemoteItem
from .vro_remote_items import VroRemoteItems
from .vro_remote_plugin_item import VroRemotePluginItem
from .vro_remote_plugin_items import VroRemotePluginItems
from .vro_remote_plugin_type import VroRemotePluginType
from .vro_remote_plugin_types import VroRemotePluginTypes
from .vro_remote_workflow_item import VroRemoteWorkflowItem
from .ws_attribute import WsAttribute
from .ws_parameter import WsParameter
from .ws_workflow_execution import WsWorkflowExecution
from .accessible_locations import AccessibleLocations
from .allocated_ip_addresses import AllocatedIpAddresses
from .application_port_profile import ApplicationPortProfile
from .application_port_profiles import ApplicationPortProfiles
from .array_param import ArrayParam
from .audit_trail_events import AuditTrailEvents
from .boolean_param import BooleanParam
from .capabilities import Capabilities
from .cells import Cells
from .chooser import Chooser
from .composite_type import CompositeType
from .composite_value import CompositeValue
from .cross_vdc_network import CrossVdcNetwork
from .cross_vdc_networks import CrossVdcNetworks
from .custom_entity_types import CustomEntityTypes
from .custom_validator import CustomValidator
from .date_param import DateParam
from .distributed_port_groups import DistributedPortGroups
from .drop_down import DropDown
from .dv_switches import DvSwitches
from .edge_clusters import EdgeClusters
from .edge_firewall_rules import EdgeFirewallRules
from .edge_gateway import EdgeGateway
from .edge_gateway_subnet import EdgeGatewaySubnet
from .edge_gateways import EdgeGateways
from .edge_ip_sec_vpn_tunnels import EdgeIpSecVpnTunnels
from .edge_nat_rules import EdgeNatRules
from .encrypted_string import EncryptedString
from .entity_references import EntityReferences
from .external_network import ExternalNetwork
from .external_networks import ExternalNetworks
from .field import Field
from .firewall_group_summary import FirewallGroupSummary
from .firewall_groups import FirewallGroups
from .gateway_used_ip_addresses import GatewayUsedIpAddresses
from .global_roles import GlobalRoles
from .group import Group
from .key_value_pair import KeyValuePair
from .logical_vm_groups import LogicalVmGroups
from .mandatory import Mandatory
from .mime_attachment import MimeAttachment
from .multi_line import MultiLine
from .network_pool_summary import NetworkPoolSummary
from .network_pools_summary import NetworkPoolsSummary
from .number_format import NumberFormat
from .number_param import NumberParam
from .number_range import NumberRange
from .port_groups import PortGroups
from .preference_definitions import PreferenceDefinitions
from .preferences import Preferences
from .properties import Properties
from .provider_vdcs import ProviderVdcs
from .proxies import Proxies
from .publishable_rights_mapping import PublishableRightsMapping
from .pvdc_compute_policies import PvdcComputePolicies
from .refresh_on_change import RefreshOnChange
from .regex import Regex
from .regexp import Regexp
from .resource_pools import ResourcePools
from .restrict_duplicates import RestrictDuplicates
from .rights import Rights
from .rights_bundles import RightsBundles
from .rights_category_nodes import RightsCategoryNodes
from .role import Role
from .roles import Roles
from .sddc_proxies import SddcProxies
from .sddcs import Sddcs
from .sdk_object import SdkObject
from .secure_string import SecureString
from .service_apps import ServiceApps
from .service_items import ServiceItems
from .services import Services
from .sessions import Sessions
from .step_info import StepInfo
from .storage_profiles import StorageProfiles
from .string_param import StringParam
from .tier0_router import Tier0Router
from .tokens import Tokens
from .ui_plugin_metadata_response import UiPluginMetadataResponse
from .used_ip_addresses import UsedIpAddresses
from .vdc_compute_policies import VdcComputePolicies
from .vdc_groups import VdcGroups
from .vdc_network import VdcNetwork
from .vdc_networks import VdcNetworks
from .vmc_sddcs import VmcSddcs
from .vro_remote_workflow_items import VroRemoteWorkflowItems
from .vro_workflow_service_item import VroWorkflowServiceItem
from .firewall_group_details import FirewallGroupDetails
from .global_role import GlobalRole
from .network_pool import NetworkPool
from .primary_field import PrimaryField
from .rights_bundle import RightsBundle
