"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class VsToVmxMapEntry(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bios_uuid': 'str',
        'datastore_path': 'str',
        'storage_profile': 'str'
    }

    attribute_map = {
        'bios_uuid': 'biosUuid',
        'datastore_path': 'datastorePath',
        'storage_profile': 'storageProfile'
    }

    def __init__(self, bios_uuid=None,datastore_path=None,storage_profile=None):
        self._bios_uuid = None
        self._datastore_path = None
        self._storage_profile = None

        if bios_uuid is not None:
            self.bios_uuid = bios_uuid
        if datastore_path is not None:
            self.datastore_path = datastore_path
        if storage_profile is not None:
            self.storage_profile = storage_profile

    @property
    def bios_uuid(self):
        return self._bios_uuid
    
    @bios_uuid.setter
    def bios_uuid(self, bios_uuid):
        self._bios_uuid = bios_uuid

    @property
    def datastore_path(self):
        return self._datastore_path
    
    @datastore_path.setter
    def datastore_path(self, datastore_path):
        self._datastore_path = datastore_path

    @property
    def storage_profile(self):
        return self._storage_profile
    
    @storage_profile.setter
    def storage_profile(self, storage_profile):
        self._storage_profile = storage_profile


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VsToVmxMapEntry):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
