"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class VmGeneralParamsType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'needs_customization': 'bool',
        'regenerate_bios_uuid': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'needs_customization': 'needsCustomization',
        'regenerate_bios_uuid': 'regenerateBiosUuid'
    }

    def __init__(self, name=None,description=None,needs_customization=None,regenerate_bios_uuid=None):
        self._name = None
        self._description = None
        self._needs_customization = None
        self._regenerate_bios_uuid = None

        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if needs_customization is not None:
            self.needs_customization = needs_customization
        if regenerate_bios_uuid is not None:
            self.regenerate_bios_uuid = regenerate_bios_uuid

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def description(self):
        return self._description
    
    @description.setter
    def description(self, description):
        self._description = description

    @property
    def needs_customization(self):
        return self._needs_customization
    
    @needs_customization.setter
    def needs_customization(self, needs_customization):
        self._needs_customization = needs_customization

    @property
    def regenerate_bios_uuid(self):
        return self._regenerate_bios_uuid
    
    @regenerate_bios_uuid.setter
    def regenerate_bios_uuid(self, regenerate_bios_uuid):
        self._regenerate_bios_uuid = regenerate_bios_uuid


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmGeneralParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
