"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class VdcTemplateSpecificationType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'nic_quota': 'int',
        'vm_quota': 'int',
        'provisioned_network_quota': 'int',
        'gateway_configuration': 'VdcTemplateSpecificationGatewayConfigurationType',
        'storage_profile': 'list[VdcStorageProfileType]'
    }

    attribute_map = {
        'nic_quota': 'nicQuota',
        'vm_quota': 'vmQuota',
        'provisioned_network_quota': 'provisionedNetworkQuota',
        'gateway_configuration': 'gatewayConfiguration',
        'storage_profile': 'storageProfile'
    }

    def __init__(self, nic_quota=None,vm_quota=None,provisioned_network_quota=None,gateway_configuration=None,storage_profile=None):
        self._nic_quota = None
        self._vm_quota = None
        self._provisioned_network_quota = None
        self._gateway_configuration = None
        self._storage_profile = None

        if nic_quota is not None:
            self.nic_quota = nic_quota
        if vm_quota is not None:
            self.vm_quota = vm_quota
        if provisioned_network_quota is not None:
            self.provisioned_network_quota = provisioned_network_quota
        if gateway_configuration is not None:
            self.gateway_configuration = gateway_configuration
        if storage_profile is not None:
            self.storage_profile = storage_profile

    @property
    def nic_quota(self):
        return self._nic_quota
    
    @nic_quota.setter
    def nic_quota(self, nic_quota):
        self._nic_quota = nic_quota

    @property
    def vm_quota(self):
        return self._vm_quota
    
    @vm_quota.setter
    def vm_quota(self, vm_quota):
        self._vm_quota = vm_quota

    @property
    def provisioned_network_quota(self):
        return self._provisioned_network_quota
    
    @provisioned_network_quota.setter
    def provisioned_network_quota(self, provisioned_network_quota):
        self._provisioned_network_quota = provisioned_network_quota

    @property
    def gateway_configuration(self):
        return self._gateway_configuration
    
    @gateway_configuration.setter
    def gateway_configuration(self, gateway_configuration):
        self._gateway_configuration = gateway_configuration

    @property
    def storage_profile(self):
        return self._storage_profile
    
    @storage_profile.setter
    def storage_profile(self, storage_profile):
        self._storage_profile = storage_profile


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VdcTemplateSpecificationType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
