"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .abstract_v_app_type import AbstractVAppType


class VAppType(AbstractVAppType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'owner': 'OwnerType',
        'auto_nature': 'bool',
        'in_maintenance_mode': 'bool',
        'children': 'VAppChildrenType',
        'ovf_descriptor_uploaded': 'bool'
    }

    attribute_map = {
        'owner': 'owner',
        'auto_nature': 'autoNature',
        'in_maintenance_mode': 'inMaintenanceMode',
        'children': 'children',
        'ovf_descriptor_uploaded': 'ovfDescriptorUploaded'
    }

    def __init__(self, owner=None,auto_nature=None,in_maintenance_mode=None,children=None,ovf_descriptor_uploaded=None):
        self._owner = None
        self._auto_nature = None
        self._in_maintenance_mode = None
        self._children = None
        self._ovf_descriptor_uploaded = None

        if owner is not None:
            self.owner = owner
        if auto_nature is not None:
            self.auto_nature = auto_nature
        if in_maintenance_mode is not None:
            self.in_maintenance_mode = in_maintenance_mode
        if children is not None:
            self.children = children
        if ovf_descriptor_uploaded is not None:
            self.ovf_descriptor_uploaded = ovf_descriptor_uploaded

    @property
    def owner(self):
        return self._owner
    
    @owner.setter
    def owner(self, owner):
        self._owner = owner

    @property
    def auto_nature(self):
        return self._auto_nature
    
    @auto_nature.setter
    def auto_nature(self, auto_nature):
        self._auto_nature = auto_nature

    @property
    def in_maintenance_mode(self):
        return self._in_maintenance_mode
    
    @in_maintenance_mode.setter
    def in_maintenance_mode(self, in_maintenance_mode):
        self._in_maintenance_mode = in_maintenance_mode

    @property
    def children(self):
        return self._children
    
    @children.setter
    def children(self, children):
        self._children = children

    @property
    def ovf_descriptor_uploaded(self):
        return self._ovf_descriptor_uploaded
    
    @ovf_descriptor_uploaded.setter
    def ovf_descriptor_uploaded(self, ovf_descriptor_uploaded):
        self._ovf_descriptor_uploaded = ovf_descriptor_uploaded


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VAppType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
