"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_entity_type import ResourceEntityType


class VAppTemplateType(ResourceEntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'owner': 'OwnerType',
        'children': 'VAppTemplateChildrenType',
        'section': 'list[SectionType]',
        'v_app_scoped_local_id': 'str',
        'default_storage_profile': 'str',
        'vdc_compute_policy': 'ReferenceType',
        'compute_policy': 'ComputePolicyType',
        'date_created': 'str',
        'gold_master': 'bool',
        'ovf_descriptor_uploaded': 'bool'
    }

    attribute_map = {
        'owner': 'owner',
        'children': 'children',
        'section': 'section',
        'v_app_scoped_local_id': 'vAppScopedLocalId',
        'default_storage_profile': 'defaultStorageProfile',
        'vdc_compute_policy': 'vdcComputePolicy',
        'compute_policy': 'computePolicy',
        'date_created': 'dateCreated',
        'gold_master': 'goldMaster',
        'ovf_descriptor_uploaded': 'ovfDescriptorUploaded'
    }

    def __init__(self, owner=None,children=None,section=None,v_app_scoped_local_id=None,default_storage_profile=None,vdc_compute_policy=None,compute_policy=None,date_created=None,gold_master=None,ovf_descriptor_uploaded=None):
        self._owner = None
        self._children = None
        self._section = None
        self._v_app_scoped_local_id = None
        self._default_storage_profile = None
        self._vdc_compute_policy = None
        self._compute_policy = None
        self._date_created = None
        self._gold_master = None
        self._ovf_descriptor_uploaded = None

        if owner is not None:
            self.owner = owner
        if children is not None:
            self.children = children
        if section is not None:
            self.section = section
        if v_app_scoped_local_id is not None:
            self.v_app_scoped_local_id = v_app_scoped_local_id
        if default_storage_profile is not None:
            self.default_storage_profile = default_storage_profile
        if vdc_compute_policy is not None:
            self.vdc_compute_policy = vdc_compute_policy
        if compute_policy is not None:
            self.compute_policy = compute_policy
        if date_created is not None:
            self.date_created = date_created
        if gold_master is not None:
            self.gold_master = gold_master
        if ovf_descriptor_uploaded is not None:
            self.ovf_descriptor_uploaded = ovf_descriptor_uploaded

    @property
    def owner(self):
        return self._owner
    
    @owner.setter
    def owner(self, owner):
        self._owner = owner

    @property
    def children(self):
        return self._children
    
    @children.setter
    def children(self, children):
        self._children = children

    @property
    def section(self):
        return self._section
    
    @section.setter
    def section(self, section):
        self._section = section

    @property
    def v_app_scoped_local_id(self):
        return self._v_app_scoped_local_id
    
    @v_app_scoped_local_id.setter
    def v_app_scoped_local_id(self, v_app_scoped_local_id):
        self._v_app_scoped_local_id = v_app_scoped_local_id

    @property
    def default_storage_profile(self):
        return self._default_storage_profile
    
    @default_storage_profile.setter
    def default_storage_profile(self, default_storage_profile):
        self._default_storage_profile = default_storage_profile

    @property
    def vdc_compute_policy(self):
        return self._vdc_compute_policy
    
    @vdc_compute_policy.setter
    def vdc_compute_policy(self, vdc_compute_policy):
        self._vdc_compute_policy = vdc_compute_policy

    @property
    def compute_policy(self):
        return self._compute_policy
    
    @compute_policy.setter
    def compute_policy(self, compute_policy):
        self._compute_policy = compute_policy

    @property
    def date_created(self):
        return self._date_created
    
    @date_created.setter
    def date_created(self, date_created):
        self._date_created = date_created

    @property
    def gold_master(self):
        return self._gold_master
    
    @gold_master.setter
    def gold_master(self, gold_master):
        self._gold_master = gold_master

    @property
    def ovf_descriptor_uploaded(self):
        return self._ovf_descriptor_uploaded
    
    @ovf_descriptor_uploaded.setter
    def ovf_descriptor_uploaded(self, ovf_descriptor_uploaded):
        self._ovf_descriptor_uploaded = ovf_descriptor_uploaded


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VAppTemplateType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
