"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class StaticRouteType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'network': 'str',
        'next_hop_ip': 'str',
        'interface': 'str',
        'gateway_interface': 'ReferenceType'
    }

    attribute_map = {
        'name': 'name',
        'network': 'network',
        'next_hop_ip': 'nextHopIp',
        'interface': 'interface',
        'gateway_interface': 'gatewayInterface'
    }

    def __init__(self, name=None,network=None,next_hop_ip=None,interface=None,gateway_interface=None):
        self._name = None
        self._network = None
        self._next_hop_ip = None
        self._interface = None
        self._gateway_interface = None

        if name is not None:
            self.name = name
        if network is not None:
            self.network = network
        if next_hop_ip is not None:
            self.next_hop_ip = next_hop_ip
        if interface is not None:
            self.interface = interface
        if gateway_interface is not None:
            self.gateway_interface = gateway_interface

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def network(self):
        return self._network
    
    @network.setter
    def network(self, network):
        self._network = network

    @property
    def next_hop_ip(self):
        return self._next_hop_ip
    
    @next_hop_ip.setter
    def next_hop_ip(self, next_hop_ip):
        self._next_hop_ip = next_hop_ip

    @property
    def interface(self):
        return self._interface
    
    @interface.setter
    def interface(self, interface):
        self._interface = interface

    @property
    def gateway_interface(self):
        return self._gateway_interface
    
    @gateway_interface.setter
    def gateway_interface(self, gateway_interface):
        self._gateway_interface = gateway_interface


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StaticRouteType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
