"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class SourcedVmInstantiationParamsType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'source': 'ReferenceType',
        'storage_profile': 'ReferenceType',
        'locality_params': 'LocalityParamsType',
        'hardware_customization': 'InstantiateVmHardwareCustomizationParamsType'
    }

    attribute_map = {
        'source': 'source',
        'storage_profile': 'storageProfile',
        'locality_params': 'localityParams',
        'hardware_customization': 'hardwareCustomization'
    }

    def __init__(self, source=None,storage_profile=None,locality_params=None,hardware_customization=None):
        self._source = None
        self._storage_profile = None
        self._locality_params = None
        self._hardware_customization = None

        if source is not None:
            self.source = source
        if storage_profile is not None:
            self.storage_profile = storage_profile
        if locality_params is not None:
            self.locality_params = locality_params
        if hardware_customization is not None:
            self.hardware_customization = hardware_customization

    @property
    def source(self):
        return self._source
    
    @source.setter
    def source(self, source):
        self._source = source

    @property
    def storage_profile(self):
        return self._storage_profile
    
    @storage_profile.setter
    def storage_profile(self, storage_profile):
        self._storage_profile = storage_profile

    @property
    def locality_params(self):
        return self._locality_params
    
    @locality_params.setter
    def locality_params(self, locality_params):
        self._locality_params = locality_params

    @property
    def hardware_customization(self):
        return self._hardware_customization
    
    @hardware_customization.setter
    def hardware_customization(self, hardware_customization):
        self._hardware_customization = hardware_customization


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SourcedVmInstantiationParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
