"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class SourcedCompositionItemParamType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'source': 'ReferenceType',
        'vm_general_params': 'VmGeneralParamsType',
        'v_app_scoped_local_id': 'str',
        'instantiation_params': 'InstantiationParamsType',
        'network_assignment': 'list[NetworkAssignmentType]',
        'storage_profile': 'ReferenceType',
        'vdc_compute_policy': 'ReferenceType',
        'compute_policy': 'ComputePolicyType',
        'locality_params': 'LocalityParamsType',
        'vm_capabilities': 'VmCapabilitiesType',
        'source_delete': 'bool'
    }

    attribute_map = {
        'source': 'source',
        'vm_general_params': 'vmGeneralParams',
        'v_app_scoped_local_id': 'vAppScopedLocalId',
        'instantiation_params': 'instantiationParams',
        'network_assignment': 'networkAssignment',
        'storage_profile': 'storageProfile',
        'vdc_compute_policy': 'vdcComputePolicy',
        'compute_policy': 'computePolicy',
        'locality_params': 'localityParams',
        'vm_capabilities': 'vmCapabilities',
        'source_delete': 'sourceDelete'
    }

    def __init__(self, source=None,vm_general_params=None,v_app_scoped_local_id=None,instantiation_params=None,network_assignment=None,storage_profile=None,vdc_compute_policy=None,compute_policy=None,locality_params=None,vm_capabilities=None,source_delete=None):
        self._source = None
        self._vm_general_params = None
        self._v_app_scoped_local_id = None
        self._instantiation_params = None
        self._network_assignment = None
        self._storage_profile = None
        self._vdc_compute_policy = None
        self._compute_policy = None
        self._locality_params = None
        self._vm_capabilities = None
        self._source_delete = None

        if source is not None:
            self.source = source
        if vm_general_params is not None:
            self.vm_general_params = vm_general_params
        if v_app_scoped_local_id is not None:
            self.v_app_scoped_local_id = v_app_scoped_local_id
        if instantiation_params is not None:
            self.instantiation_params = instantiation_params
        if network_assignment is not None:
            self.network_assignment = network_assignment
        if storage_profile is not None:
            self.storage_profile = storage_profile
        if vdc_compute_policy is not None:
            self.vdc_compute_policy = vdc_compute_policy
        if compute_policy is not None:
            self.compute_policy = compute_policy
        if locality_params is not None:
            self.locality_params = locality_params
        if vm_capabilities is not None:
            self.vm_capabilities = vm_capabilities
        if source_delete is not None:
            self.source_delete = source_delete

    @property
    def source(self):
        return self._source
    
    @source.setter
    def source(self, source):
        self._source = source

    @property
    def vm_general_params(self):
        return self._vm_general_params
    
    @vm_general_params.setter
    def vm_general_params(self, vm_general_params):
        self._vm_general_params = vm_general_params

    @property
    def v_app_scoped_local_id(self):
        return self._v_app_scoped_local_id
    
    @v_app_scoped_local_id.setter
    def v_app_scoped_local_id(self, v_app_scoped_local_id):
        self._v_app_scoped_local_id = v_app_scoped_local_id

    @property
    def instantiation_params(self):
        return self._instantiation_params
    
    @instantiation_params.setter
    def instantiation_params(self, instantiation_params):
        self._instantiation_params = instantiation_params

    @property
    def network_assignment(self):
        return self._network_assignment
    
    @network_assignment.setter
    def network_assignment(self, network_assignment):
        self._network_assignment = network_assignment

    @property
    def storage_profile(self):
        return self._storage_profile
    
    @storage_profile.setter
    def storage_profile(self, storage_profile):
        self._storage_profile = storage_profile

    @property
    def vdc_compute_policy(self):
        return self._vdc_compute_policy
    
    @vdc_compute_policy.setter
    def vdc_compute_policy(self, vdc_compute_policy):
        self._vdc_compute_policy = vdc_compute_policy

    @property
    def compute_policy(self):
        return self._compute_policy
    
    @compute_policy.setter
    def compute_policy(self, compute_policy):
        self._compute_policy = compute_policy

    @property
    def locality_params(self):
        return self._locality_params
    
    @locality_params.setter
    def locality_params(self, locality_params):
        self._locality_params = locality_params

    @property
    def vm_capabilities(self):
        return self._vm_capabilities
    
    @vm_capabilities.setter
    def vm_capabilities(self, vm_capabilities):
        self._vm_capabilities = vm_capabilities

    @property
    def source_delete(self):
        return self._source_delete
    
    @source_delete.setter
    def source_delete(self, source_delete):
        self._source_delete = source_delete


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SourcedCompositionItemParamType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
