"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class SnapshotType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'created': 'str',
        'powered_on': 'bool',
        'size': 'int'
    }

    attribute_map = {
        'created': 'created',
        'powered_on': 'poweredOn',
        'size': 'size'
    }

    def __init__(self, created=None,powered_on=None,size=None):
        self._created = None
        self._powered_on = None
        self._size = None

        if created is not None:
            self.created = created
        if powered_on is not None:
            self.powered_on = powered_on
        if size is not None:
            self.size = size

    @property
    def created(self):
        return self._created
    
    @created.setter
    def created(self, created):
        self._created = created

    @property
    def powered_on(self):
        return self._powered_on
    
    @powered_on.setter
    def powered_on(self, powered_on):
        self._powered_on = powered_on

    @property
    def size(self):
        return self._size
    
    @size.setter
    def size(self, size):
        self._size = size


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
