"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .params_type import ParamsType


class RegisterVAppParamsType(ParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ovf': 'str',
        'vs_to_vmx_map': 'VsToVmxMapType',
        'ovf_to_vdc_network_map': 'OvfToVdcNetworkMapType',
        'external_nat_ip_map': 'ExternalNatIpMapType',
        'nic_ip_map': 'NicIpMapType'
    }

    attribute_map = {
        'ovf': 'ovf',
        'vs_to_vmx_map': 'vsToVmxMap',
        'ovf_to_vdc_network_map': 'ovfToVdcNetworkMap',
        'external_nat_ip_map': 'externalNatIpMap',
        'nic_ip_map': 'nicIpMap'
    }

    def __init__(self, ovf=None,vs_to_vmx_map=None,ovf_to_vdc_network_map=None,external_nat_ip_map=None,nic_ip_map=None):
        self._ovf = None
        self._vs_to_vmx_map = None
        self._ovf_to_vdc_network_map = None
        self._external_nat_ip_map = None
        self._nic_ip_map = None

        if ovf is not None:
            self.ovf = ovf
        if vs_to_vmx_map is not None:
            self.vs_to_vmx_map = vs_to_vmx_map
        if ovf_to_vdc_network_map is not None:
            self.ovf_to_vdc_network_map = ovf_to_vdc_network_map
        if external_nat_ip_map is not None:
            self.external_nat_ip_map = external_nat_ip_map
        if nic_ip_map is not None:
            self.nic_ip_map = nic_ip_map

    @property
    def ovf(self):
        return self._ovf
    
    @ovf.setter
    def ovf(self, ovf):
        self._ovf = ovf

    @property
    def vs_to_vmx_map(self):
        return self._vs_to_vmx_map
    
    @vs_to_vmx_map.setter
    def vs_to_vmx_map(self, vs_to_vmx_map):
        self._vs_to_vmx_map = vs_to_vmx_map

    @property
    def ovf_to_vdc_network_map(self):
        return self._ovf_to_vdc_network_map
    
    @ovf_to_vdc_network_map.setter
    def ovf_to_vdc_network_map(self, ovf_to_vdc_network_map):
        self._ovf_to_vdc_network_map = ovf_to_vdc_network_map

    @property
    def external_nat_ip_map(self):
        return self._external_nat_ip_map
    
    @external_nat_ip_map.setter
    def external_nat_ip_map(self, external_nat_ip_map):
        self._external_nat_ip_map = external_nat_ip_map

    @property
    def nic_ip_map(self):
        return self._nic_ip_map
    
    @nic_ip_map.setter
    def nic_ip_map(self, nic_ip_map):
        self._nic_ip_map = nic_ip_map


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RegisterVAppParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
