"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultVMRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'auto_delete_date': 'str',
        'auto_undeploy_date': 'str',
        'catalog_name': 'str',
        'container': 'str',
        'container_name': 'str',
        'gc_status': 'str',
        'guest_os': 'str',
        'hardware_version': 'int',
        'ip_address': 'str',
        'is_auto_delete_notified': 'bool',
        'is_auto_nature': 'bool',
        'is_auto_undeploy_notified': 'bool',
        'is_busy': 'bool',
        'is_deleted': 'bool',
        'is_deployed': 'bool',
        'is_in_maintenance_mode': 'bool',
        'is_published': 'bool',
        'is_v_app_template': 'bool',
        'memory_mb': 'int',
        'name': 'str',
        'network': 'str',
        'network_name': 'str',
        'number_of_cpus': 'int',
        'owner': 'str',
        'owner_name': 'str',
        'status': 'str',
        'storage_profile_name': 'str',
        'vdc': 'str',
        'vm_tools_status': 'str'
    }

    attribute_map = {
        'auto_delete_date': 'autoDeleteDate',
        'auto_undeploy_date': 'autoUndeployDate',
        'catalog_name': 'catalogName',
        'container': 'container',
        'container_name': 'containerName',
        'gc_status': 'gcStatus',
        'guest_os': 'guestOs',
        'hardware_version': 'hardwareVersion',
        'ip_address': 'ipAddress',
        'is_auto_delete_notified': 'isAutoDeleteNotified',
        'is_auto_nature': 'isAutoNature',
        'is_auto_undeploy_notified': 'isAutoUndeployNotified',
        'is_busy': 'isBusy',
        'is_deleted': 'isDeleted',
        'is_deployed': 'isDeployed',
        'is_in_maintenance_mode': 'isInMaintenanceMode',
        'is_published': 'isPublished',
        'is_v_app_template': 'isVAppTemplate',
        'memory_mb': 'memoryMB',
        'name': 'name',
        'network': 'network',
        'network_name': 'networkName',
        'number_of_cpus': 'numberOfCpus',
        'owner': 'owner',
        'owner_name': 'ownerName',
        'status': 'status',
        'storage_profile_name': 'storageProfileName',
        'vdc': 'vdc',
        'vm_tools_status': 'vmToolsStatus'
    }

    def __init__(self, auto_delete_date=None,auto_undeploy_date=None,catalog_name=None,container=None,container_name=None,gc_status=None,guest_os=None,hardware_version=None,ip_address=None,is_auto_delete_notified=None,is_auto_nature=None,is_auto_undeploy_notified=None,is_busy=None,is_deleted=None,is_deployed=None,is_in_maintenance_mode=None,is_published=None,is_v_app_template=None,memory_mb=None,name=None,network=None,network_name=None,number_of_cpus=None,owner=None,owner_name=None,status=None,storage_profile_name=None,vdc=None,vm_tools_status=None):
        self._auto_delete_date = None
        self._auto_undeploy_date = None
        self._catalog_name = None
        self._container = None
        self._container_name = None
        self._gc_status = None
        self._guest_os = None
        self._hardware_version = None
        self._ip_address = None
        self._is_auto_delete_notified = None
        self._is_auto_nature = None
        self._is_auto_undeploy_notified = None
        self._is_busy = None
        self._is_deleted = None
        self._is_deployed = None
        self._is_in_maintenance_mode = None
        self._is_published = None
        self._is_v_app_template = None
        self._memory_mb = None
        self._name = None
        self._network = None
        self._network_name = None
        self._number_of_cpus = None
        self._owner = None
        self._owner_name = None
        self._status = None
        self._storage_profile_name = None
        self._vdc = None
        self._vm_tools_status = None

        if auto_delete_date is not None:
            self.auto_delete_date = auto_delete_date
        if auto_undeploy_date is not None:
            self.auto_undeploy_date = auto_undeploy_date
        if catalog_name is not None:
            self.catalog_name = catalog_name
        if container is not None:
            self.container = container
        if container_name is not None:
            self.container_name = container_name
        if gc_status is not None:
            self.gc_status = gc_status
        if guest_os is not None:
            self.guest_os = guest_os
        if hardware_version is not None:
            self.hardware_version = hardware_version
        if ip_address is not None:
            self.ip_address = ip_address
        if is_auto_delete_notified is not None:
            self.is_auto_delete_notified = is_auto_delete_notified
        if is_auto_nature is not None:
            self.is_auto_nature = is_auto_nature
        if is_auto_undeploy_notified is not None:
            self.is_auto_undeploy_notified = is_auto_undeploy_notified
        if is_busy is not None:
            self.is_busy = is_busy
        if is_deleted is not None:
            self.is_deleted = is_deleted
        if is_deployed is not None:
            self.is_deployed = is_deployed
        if is_in_maintenance_mode is not None:
            self.is_in_maintenance_mode = is_in_maintenance_mode
        if is_published is not None:
            self.is_published = is_published
        if is_v_app_template is not None:
            self.is_v_app_template = is_v_app_template
        if memory_mb is not None:
            self.memory_mb = memory_mb
        if name is not None:
            self.name = name
        if network is not None:
            self.network = network
        if network_name is not None:
            self.network_name = network_name
        if number_of_cpus is not None:
            self.number_of_cpus = number_of_cpus
        if owner is not None:
            self.owner = owner
        if owner_name is not None:
            self.owner_name = owner_name
        if status is not None:
            self.status = status
        if storage_profile_name is not None:
            self.storage_profile_name = storage_profile_name
        if vdc is not None:
            self.vdc = vdc
        if vm_tools_status is not None:
            self.vm_tools_status = vm_tools_status

    @property
    def auto_delete_date(self):
        return self._auto_delete_date
    
    @auto_delete_date.setter
    def auto_delete_date(self, auto_delete_date):
        self._auto_delete_date = auto_delete_date

    @property
    def auto_undeploy_date(self):
        return self._auto_undeploy_date
    
    @auto_undeploy_date.setter
    def auto_undeploy_date(self, auto_undeploy_date):
        self._auto_undeploy_date = auto_undeploy_date

    @property
    def catalog_name(self):
        return self._catalog_name
    
    @catalog_name.setter
    def catalog_name(self, catalog_name):
        self._catalog_name = catalog_name

    @property
    def container(self):
        return self._container
    
    @container.setter
    def container(self, container):
        self._container = container

    @property
    def container_name(self):
        return self._container_name
    
    @container_name.setter
    def container_name(self, container_name):
        self._container_name = container_name

    @property
    def gc_status(self):
        return self._gc_status
    
    @gc_status.setter
    def gc_status(self, gc_status):
        self._gc_status = gc_status

    @property
    def guest_os(self):
        return self._guest_os
    
    @guest_os.setter
    def guest_os(self, guest_os):
        self._guest_os = guest_os

    @property
    def hardware_version(self):
        return self._hardware_version
    
    @hardware_version.setter
    def hardware_version(self, hardware_version):
        self._hardware_version = hardware_version

    @property
    def ip_address(self):
        return self._ip_address
    
    @ip_address.setter
    def ip_address(self, ip_address):
        self._ip_address = ip_address

    @property
    def is_auto_delete_notified(self):
        return self._is_auto_delete_notified
    
    @is_auto_delete_notified.setter
    def is_auto_delete_notified(self, is_auto_delete_notified):
        self._is_auto_delete_notified = is_auto_delete_notified

    @property
    def is_auto_nature(self):
        return self._is_auto_nature
    
    @is_auto_nature.setter
    def is_auto_nature(self, is_auto_nature):
        self._is_auto_nature = is_auto_nature

    @property
    def is_auto_undeploy_notified(self):
        return self._is_auto_undeploy_notified
    
    @is_auto_undeploy_notified.setter
    def is_auto_undeploy_notified(self, is_auto_undeploy_notified):
        self._is_auto_undeploy_notified = is_auto_undeploy_notified

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def is_deleted(self):
        return self._is_deleted
    
    @is_deleted.setter
    def is_deleted(self, is_deleted):
        self._is_deleted = is_deleted

    @property
    def is_deployed(self):
        return self._is_deployed
    
    @is_deployed.setter
    def is_deployed(self, is_deployed):
        self._is_deployed = is_deployed

    @property
    def is_in_maintenance_mode(self):
        return self._is_in_maintenance_mode
    
    @is_in_maintenance_mode.setter
    def is_in_maintenance_mode(self, is_in_maintenance_mode):
        self._is_in_maintenance_mode = is_in_maintenance_mode

    @property
    def is_published(self):
        return self._is_published
    
    @is_published.setter
    def is_published(self, is_published):
        self._is_published = is_published

    @property
    def is_v_app_template(self):
        return self._is_v_app_template
    
    @is_v_app_template.setter
    def is_v_app_template(self, is_v_app_template):
        self._is_v_app_template = is_v_app_template

    @property
    def memory_mb(self):
        return self._memory_mb
    
    @memory_mb.setter
    def memory_mb(self, memory_mb):
        self._memory_mb = memory_mb

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def network(self):
        return self._network
    
    @network.setter
    def network(self, network):
        self._network = network

    @property
    def network_name(self):
        return self._network_name
    
    @network_name.setter
    def network_name(self, network_name):
        self._network_name = network_name

    @property
    def number_of_cpus(self):
        return self._number_of_cpus
    
    @number_of_cpus.setter
    def number_of_cpus(self, number_of_cpus):
        self._number_of_cpus = number_of_cpus

    @property
    def owner(self):
        return self._owner
    
    @owner.setter
    def owner(self, owner):
        self._owner = owner

    @property
    def owner_name(self):
        return self._owner_name
    
    @owner_name.setter
    def owner_name(self, owner_name):
        self._owner_name = owner_name

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def storage_profile_name(self):
        return self._storage_profile_name
    
    @storage_profile_name.setter
    def storage_profile_name(self, storage_profile_name):
        self._storage_profile_name = storage_profile_name

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc

    @property
    def vm_tools_status(self):
        return self._vm_tools_status
    
    @vm_tools_status.setter
    def vm_tools_status(self, vm_tools_status):
        self._vm_tools_status = vm_tools_status


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultVMRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
