"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultVAppNetworkRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'dns1': 'str',
        'dns2': 'str',
        'dns_suffix': 'str',
        'gateway': 'str',
        'ip_scope_id': 'str',
        'is_busy': 'bool',
        'is_ip_scope_inherited': 'bool',
        'name': 'str',
        'netmask': 'str',
        'v_app': 'str',
        'v_app_name': 'str'
    }

    attribute_map = {
        'dns1': 'dns1',
        'dns2': 'dns2',
        'dns_suffix': 'dnsSuffix',
        'gateway': 'gateway',
        'ip_scope_id': 'ipScopeId',
        'is_busy': 'isBusy',
        'is_ip_scope_inherited': 'isIpScopeInherited',
        'name': 'name',
        'netmask': 'netmask',
        'v_app': 'vApp',
        'v_app_name': 'vAppName'
    }

    def __init__(self, dns1=None,dns2=None,dns_suffix=None,gateway=None,ip_scope_id=None,is_busy=None,is_ip_scope_inherited=None,name=None,netmask=None,v_app=None,v_app_name=None):
        self._dns1 = None
        self._dns2 = None
        self._dns_suffix = None
        self._gateway = None
        self._ip_scope_id = None
        self._is_busy = None
        self._is_ip_scope_inherited = None
        self._name = None
        self._netmask = None
        self._v_app = None
        self._v_app_name = None

        if dns1 is not None:
            self.dns1 = dns1
        if dns2 is not None:
            self.dns2 = dns2
        if dns_suffix is not None:
            self.dns_suffix = dns_suffix
        if gateway is not None:
            self.gateway = gateway
        if ip_scope_id is not None:
            self.ip_scope_id = ip_scope_id
        if is_busy is not None:
            self.is_busy = is_busy
        if is_ip_scope_inherited is not None:
            self.is_ip_scope_inherited = is_ip_scope_inherited
        if name is not None:
            self.name = name
        if netmask is not None:
            self.netmask = netmask
        if v_app is not None:
            self.v_app = v_app
        if v_app_name is not None:
            self.v_app_name = v_app_name

    @property
    def dns1(self):
        return self._dns1
    
    @dns1.setter
    def dns1(self, dns1):
        self._dns1 = dns1

    @property
    def dns2(self):
        return self._dns2
    
    @dns2.setter
    def dns2(self, dns2):
        self._dns2 = dns2

    @property
    def dns_suffix(self):
        return self._dns_suffix
    
    @dns_suffix.setter
    def dns_suffix(self, dns_suffix):
        self._dns_suffix = dns_suffix

    @property
    def gateway(self):
        return self._gateway
    
    @gateway.setter
    def gateway(self, gateway):
        self._gateway = gateway

    @property
    def ip_scope_id(self):
        return self._ip_scope_id
    
    @ip_scope_id.setter
    def ip_scope_id(self, ip_scope_id):
        self._ip_scope_id = ip_scope_id

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def is_ip_scope_inherited(self):
        return self._is_ip_scope_inherited
    
    @is_ip_scope_inherited.setter
    def is_ip_scope_inherited(self, is_ip_scope_inherited):
        self._is_ip_scope_inherited = is_ip_scope_inherited

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def netmask(self):
        return self._netmask
    
    @netmask.setter
    def netmask(self, netmask):
        self._netmask = netmask

    @property
    def v_app(self):
        return self._v_app
    
    @v_app.setter
    def v_app(self, v_app):
        self._v_app = v_app

    @property
    def v_app_name(self):
        return self._v_app_name
    
    @v_app_name.setter
    def v_app_name(self, v_app_name):
        self._v_app_name = v_app_name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultVAppNetworkRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
