"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultProviderVdcStorageProfileRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'iops_allocated': 'int',
        'iops_capacity': 'int',
        'is_enabled': 'bool',
        'name': 'str',
        'number_of_conditions': 'int',
        'provider_vdc': 'str',
        'storage_profile_moref': 'str',
        'storage_provisioned_mb': 'int',
        'storage_requested_mb': 'int',
        'storage_total_mb': 'int',
        'storage_used_mb': 'int',
        'vc': 'str'
    }

    attribute_map = {
        'iops_allocated': 'iopsAllocated',
        'iops_capacity': 'iopsCapacity',
        'is_enabled': 'isEnabled',
        'name': 'name',
        'number_of_conditions': 'numberOfConditions',
        'provider_vdc': 'providerVdc',
        'storage_profile_moref': 'storageProfileMoref',
        'storage_provisioned_mb': 'storageProvisionedMB',
        'storage_requested_mb': 'storageRequestedMB',
        'storage_total_mb': 'storageTotalMB',
        'storage_used_mb': 'storageUsedMB',
        'vc': 'vc'
    }

    def __init__(self, iops_allocated=None,iops_capacity=None,is_enabled=None,name=None,number_of_conditions=None,provider_vdc=None,storage_profile_moref=None,storage_provisioned_mb=None,storage_requested_mb=None,storage_total_mb=None,storage_used_mb=None,vc=None):
        self._iops_allocated = None
        self._iops_capacity = None
        self._is_enabled = None
        self._name = None
        self._number_of_conditions = None
        self._provider_vdc = None
        self._storage_profile_moref = None
        self._storage_provisioned_mb = None
        self._storage_requested_mb = None
        self._storage_total_mb = None
        self._storage_used_mb = None
        self._vc = None

        if iops_allocated is not None:
            self.iops_allocated = iops_allocated
        if iops_capacity is not None:
            self.iops_capacity = iops_capacity
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if name is not None:
            self.name = name
        if number_of_conditions is not None:
            self.number_of_conditions = number_of_conditions
        if provider_vdc is not None:
            self.provider_vdc = provider_vdc
        if storage_profile_moref is not None:
            self.storage_profile_moref = storage_profile_moref
        if storage_provisioned_mb is not None:
            self.storage_provisioned_mb = storage_provisioned_mb
        if storage_requested_mb is not None:
            self.storage_requested_mb = storage_requested_mb
        if storage_total_mb is not None:
            self.storage_total_mb = storage_total_mb
        if storage_used_mb is not None:
            self.storage_used_mb = storage_used_mb
        if vc is not None:
            self.vc = vc

    @property
    def iops_allocated(self):
        return self._iops_allocated
    
    @iops_allocated.setter
    def iops_allocated(self, iops_allocated):
        self._iops_allocated = iops_allocated

    @property
    def iops_capacity(self):
        return self._iops_capacity
    
    @iops_capacity.setter
    def iops_capacity(self, iops_capacity):
        self._iops_capacity = iops_capacity

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def number_of_conditions(self):
        return self._number_of_conditions
    
    @number_of_conditions.setter
    def number_of_conditions(self, number_of_conditions):
        self._number_of_conditions = number_of_conditions

    @property
    def provider_vdc(self):
        return self._provider_vdc
    
    @provider_vdc.setter
    def provider_vdc(self, provider_vdc):
        self._provider_vdc = provider_vdc

    @property
    def storage_profile_moref(self):
        return self._storage_profile_moref
    
    @storage_profile_moref.setter
    def storage_profile_moref(self, storage_profile_moref):
        self._storage_profile_moref = storage_profile_moref

    @property
    def storage_provisioned_mb(self):
        return self._storage_provisioned_mb
    
    @storage_provisioned_mb.setter
    def storage_provisioned_mb(self, storage_provisioned_mb):
        self._storage_provisioned_mb = storage_provisioned_mb

    @property
    def storage_requested_mb(self):
        return self._storage_requested_mb
    
    @storage_requested_mb.setter
    def storage_requested_mb(self, storage_requested_mb):
        self._storage_requested_mb = storage_requested_mb

    @property
    def storage_total_mb(self):
        return self._storage_total_mb
    
    @storage_total_mb.setter
    def storage_total_mb(self, storage_total_mb):
        self._storage_total_mb = storage_total_mb

    @property
    def storage_used_mb(self):
        return self._storage_used_mb
    
    @storage_used_mb.setter
    def storage_used_mb(self, storage_used_mb):
        self._storage_used_mb = storage_used_mb

    @property
    def vc(self):
        return self._vc
    
    @vc.setter
    def vc(self, vc):
        self._vc = vc


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultProviderVdcStorageProfileRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
