"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultOrgVdcNetworkRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'connected_to': 'str',
        'cross_vdc_network_id': 'str',
        'cross_vdc_network_site_id': 'str',
        'default_gateway': 'str',
        'dns1': 'str',
        'dns2': 'str',
        'dns_suffix': 'str',
        'interface_type': 'int',
        'is_busy': 'bool',
        'is_ip_scope_inherited': 'bool',
        'is_shared': 'bool',
        'link_type': 'int',
        'name': 'str',
        'netmask': 'str',
        'total_ip_count': 'int',
        'used_ip_count': 'int',
        'vdc': 'str',
        'vdc_name': 'str'
    }

    attribute_map = {
        'connected_to': 'connectedTo',
        'cross_vdc_network_id': 'crossVdcNetworkId',
        'cross_vdc_network_site_id': 'crossVdcNetworkSiteId',
        'default_gateway': 'defaultGateway',
        'dns1': 'dns1',
        'dns2': 'dns2',
        'dns_suffix': 'dnsSuffix',
        'interface_type': 'interfaceType',
        'is_busy': 'isBusy',
        'is_ip_scope_inherited': 'isIpScopeInherited',
        'is_shared': 'isShared',
        'link_type': 'linkType',
        'name': 'name',
        'netmask': 'netmask',
        'total_ip_count': 'totalIpCount',
        'used_ip_count': 'usedIpCount',
        'vdc': 'vdc',
        'vdc_name': 'vdcName'
    }

    def __init__(self, connected_to=None,cross_vdc_network_id=None,cross_vdc_network_site_id=None,default_gateway=None,dns1=None,dns2=None,dns_suffix=None,interface_type=None,is_busy=None,is_ip_scope_inherited=None,is_shared=None,link_type=None,name=None,netmask=None,total_ip_count=None,used_ip_count=None,vdc=None,vdc_name=None):
        self._connected_to = None
        self._cross_vdc_network_id = None
        self._cross_vdc_network_site_id = None
        self._default_gateway = None
        self._dns1 = None
        self._dns2 = None
        self._dns_suffix = None
        self._interface_type = None
        self._is_busy = None
        self._is_ip_scope_inherited = None
        self._is_shared = None
        self._link_type = None
        self._name = None
        self._netmask = None
        self._total_ip_count = None
        self._used_ip_count = None
        self._vdc = None
        self._vdc_name = None

        if connected_to is not None:
            self.connected_to = connected_to
        if cross_vdc_network_id is not None:
            self.cross_vdc_network_id = cross_vdc_network_id
        if cross_vdc_network_site_id is not None:
            self.cross_vdc_network_site_id = cross_vdc_network_site_id
        if default_gateway is not None:
            self.default_gateway = default_gateway
        if dns1 is not None:
            self.dns1 = dns1
        if dns2 is not None:
            self.dns2 = dns2
        if dns_suffix is not None:
            self.dns_suffix = dns_suffix
        if interface_type is not None:
            self.interface_type = interface_type
        if is_busy is not None:
            self.is_busy = is_busy
        if is_ip_scope_inherited is not None:
            self.is_ip_scope_inherited = is_ip_scope_inherited
        if is_shared is not None:
            self.is_shared = is_shared
        if link_type is not None:
            self.link_type = link_type
        if name is not None:
            self.name = name
        if netmask is not None:
            self.netmask = netmask
        if total_ip_count is not None:
            self.total_ip_count = total_ip_count
        if used_ip_count is not None:
            self.used_ip_count = used_ip_count
        if vdc is not None:
            self.vdc = vdc
        if vdc_name is not None:
            self.vdc_name = vdc_name

    @property
    def connected_to(self):
        return self._connected_to
    
    @connected_to.setter
    def connected_to(self, connected_to):
        self._connected_to = connected_to

    @property
    def cross_vdc_network_id(self):
        return self._cross_vdc_network_id
    
    @cross_vdc_network_id.setter
    def cross_vdc_network_id(self, cross_vdc_network_id):
        self._cross_vdc_network_id = cross_vdc_network_id

    @property
    def cross_vdc_network_site_id(self):
        return self._cross_vdc_network_site_id
    
    @cross_vdc_network_site_id.setter
    def cross_vdc_network_site_id(self, cross_vdc_network_site_id):
        self._cross_vdc_network_site_id = cross_vdc_network_site_id

    @property
    def default_gateway(self):
        return self._default_gateway
    
    @default_gateway.setter
    def default_gateway(self, default_gateway):
        self._default_gateway = default_gateway

    @property
    def dns1(self):
        return self._dns1
    
    @dns1.setter
    def dns1(self, dns1):
        self._dns1 = dns1

    @property
    def dns2(self):
        return self._dns2
    
    @dns2.setter
    def dns2(self, dns2):
        self._dns2 = dns2

    @property
    def dns_suffix(self):
        return self._dns_suffix
    
    @dns_suffix.setter
    def dns_suffix(self, dns_suffix):
        self._dns_suffix = dns_suffix

    @property
    def interface_type(self):
        return self._interface_type
    
    @interface_type.setter
    def interface_type(self, interface_type):
        self._interface_type = interface_type

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def is_ip_scope_inherited(self):
        return self._is_ip_scope_inherited
    
    @is_ip_scope_inherited.setter
    def is_ip_scope_inherited(self, is_ip_scope_inherited):
        self._is_ip_scope_inherited = is_ip_scope_inherited

    @property
    def is_shared(self):
        return self._is_shared
    
    @is_shared.setter
    def is_shared(self, is_shared):
        self._is_shared = is_shared

    @property
    def link_type(self):
        return self._link_type
    
    @link_type.setter
    def link_type(self, link_type):
        self._link_type = link_type

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def netmask(self):
        return self._netmask
    
    @netmask.setter
    def netmask(self, netmask):
        self._netmask = netmask

    @property
    def total_ip_count(self):
        return self._total_ip_count
    
    @total_ip_count.setter
    def total_ip_count(self, total_ip_count):
        self._total_ip_count = total_ip_count

    @property
    def used_ip_count(self):
        return self._used_ip_count
    
    @used_ip_count.setter
    def used_ip_count(self, used_ip_count):
        self._used_ip_count = used_ip_count

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc

    @property
    def vdc_name(self):
        return self._vdc_name
    
    @vdc_name.setter
    def vdc_name(self, vdc_name):
        self._vdc_name = vdc_name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultOrgVdcNetworkRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
