"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultLicensingReportSampleRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'allocated_virtual_memory': 'int',
        'observation_date': 'str',
        'parent_report_id': 'str',
        'physical_memory_used': 'int',
        'physical_socket_count': 'int',
        'publishing_to_remote_sites': 'bool',
        'sample_id': 'str',
        'subscribing_to_remote_sites': 'bool',
        'total_physical_memory': 'int',
        'virtual_processor_count': 'int',
        'vm_count': 'int'
    }

    attribute_map = {
        'allocated_virtual_memory': 'allocatedVirtualMemory',
        'observation_date': 'observationDate',
        'parent_report_id': 'parentReportId',
        'physical_memory_used': 'physicalMemoryUsed',
        'physical_socket_count': 'physicalSocketCount',
        'publishing_to_remote_sites': 'publishingToRemoteSites',
        'sample_id': 'sampleId',
        'subscribing_to_remote_sites': 'subscribingToRemoteSites',
        'total_physical_memory': 'totalPhysicalMemory',
        'virtual_processor_count': 'virtualProcessorCount',
        'vm_count': 'vmCount'
    }

    def __init__(self, allocated_virtual_memory=None,observation_date=None,parent_report_id=None,physical_memory_used=None,physical_socket_count=None,publishing_to_remote_sites=None,sample_id=None,subscribing_to_remote_sites=None,total_physical_memory=None,virtual_processor_count=None,vm_count=None):
        self._allocated_virtual_memory = None
        self._observation_date = None
        self._parent_report_id = None
        self._physical_memory_used = None
        self._physical_socket_count = None
        self._publishing_to_remote_sites = None
        self._sample_id = None
        self._subscribing_to_remote_sites = None
        self._total_physical_memory = None
        self._virtual_processor_count = None
        self._vm_count = None

        if allocated_virtual_memory is not None:
            self.allocated_virtual_memory = allocated_virtual_memory
        if observation_date is not None:
            self.observation_date = observation_date
        if parent_report_id is not None:
            self.parent_report_id = parent_report_id
        if physical_memory_used is not None:
            self.physical_memory_used = physical_memory_used
        if physical_socket_count is not None:
            self.physical_socket_count = physical_socket_count
        if publishing_to_remote_sites is not None:
            self.publishing_to_remote_sites = publishing_to_remote_sites
        if sample_id is not None:
            self.sample_id = sample_id
        if subscribing_to_remote_sites is not None:
            self.subscribing_to_remote_sites = subscribing_to_remote_sites
        if total_physical_memory is not None:
            self.total_physical_memory = total_physical_memory
        if virtual_processor_count is not None:
            self.virtual_processor_count = virtual_processor_count
        if vm_count is not None:
            self.vm_count = vm_count

    @property
    def allocated_virtual_memory(self):
        return self._allocated_virtual_memory
    
    @allocated_virtual_memory.setter
    def allocated_virtual_memory(self, allocated_virtual_memory):
        self._allocated_virtual_memory = allocated_virtual_memory

    @property
    def observation_date(self):
        return self._observation_date
    
    @observation_date.setter
    def observation_date(self, observation_date):
        self._observation_date = observation_date

    @property
    def parent_report_id(self):
        return self._parent_report_id
    
    @parent_report_id.setter
    def parent_report_id(self, parent_report_id):
        self._parent_report_id = parent_report_id

    @property
    def physical_memory_used(self):
        return self._physical_memory_used
    
    @physical_memory_used.setter
    def physical_memory_used(self, physical_memory_used):
        self._physical_memory_used = physical_memory_used

    @property
    def physical_socket_count(self):
        return self._physical_socket_count
    
    @physical_socket_count.setter
    def physical_socket_count(self, physical_socket_count):
        self._physical_socket_count = physical_socket_count

    @property
    def publishing_to_remote_sites(self):
        return self._publishing_to_remote_sites
    
    @publishing_to_remote_sites.setter
    def publishing_to_remote_sites(self, publishing_to_remote_sites):
        self._publishing_to_remote_sites = publishing_to_remote_sites

    @property
    def sample_id(self):
        return self._sample_id
    
    @sample_id.setter
    def sample_id(self, sample_id):
        self._sample_id = sample_id

    @property
    def subscribing_to_remote_sites(self):
        return self._subscribing_to_remote_sites
    
    @subscribing_to_remote_sites.setter
    def subscribing_to_remote_sites(self, subscribing_to_remote_sites):
        self._subscribing_to_remote_sites = subscribing_to_remote_sites

    @property
    def total_physical_memory(self):
        return self._total_physical_memory
    
    @total_physical_memory.setter
    def total_physical_memory(self, total_physical_memory):
        self._total_physical_memory = total_physical_memory

    @property
    def virtual_processor_count(self):
        return self._virtual_processor_count
    
    @virtual_processor_count.setter
    def virtual_processor_count(self, virtual_processor_count):
        self._virtual_processor_count = virtual_processor_count

    @property
    def vm_count(self):
        return self._vm_count
    
    @vm_count.setter
    def vm_count(self, vm_count):
        self._vm_count = vm_count


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultLicensingReportSampleRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
