"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultFromCloudTunnelRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'destination_host': 'str',
        'destination_id': 'str',
        'destination_port': 'int',
        'org': 'str',
        'traffic_type': 'str'
    }

    attribute_map = {
        'destination_host': 'destinationHost',
        'destination_id': 'destinationId',
        'destination_port': 'destinationPort',
        'org': 'org',
        'traffic_type': 'trafficType'
    }

    def __init__(self, destination_host=None,destination_id=None,destination_port=None,org=None,traffic_type=None):
        self._destination_host = None
        self._destination_id = None
        self._destination_port = None
        self._org = None
        self._traffic_type = None

        if destination_host is not None:
            self.destination_host = destination_host
        if destination_id is not None:
            self.destination_id = destination_id
        if destination_port is not None:
            self.destination_port = destination_port
        if org is not None:
            self.org = org
        if traffic_type is not None:
            self.traffic_type = traffic_type

    @property
    def destination_host(self):
        return self._destination_host
    
    @destination_host.setter
    def destination_host(self, destination_host):
        self._destination_host = destination_host

    @property
    def destination_id(self):
        return self._destination_id
    
    @destination_id.setter
    def destination_id(self, destination_id):
        self._destination_id = destination_id

    @property
    def destination_port(self):
        return self._destination_port
    
    @destination_port.setter
    def destination_port(self, destination_port):
        self._destination_port = destination_port

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def traffic_type(self):
        return self._traffic_type
    
    @traffic_type.setter
    def traffic_type(self, traffic_type):
        self._traffic_type = traffic_type


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultFromCloudTunnelRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
