"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultFileDescriptorRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'api_definition': 'str',
        'api_name': 'str',
        'api_namespace': 'str',
        'api_vendor': 'str',
        'file_mime_type': 'str',
        'file_url': 'str',
        'name': 'str',
        'service': 'str',
        'service_name': 'str',
        'service_namespace': 'str',
        'service_vendor': 'str'
    }

    attribute_map = {
        'api_definition': 'apiDefinition',
        'api_name': 'apiName',
        'api_namespace': 'apiNamespace',
        'api_vendor': 'apiVendor',
        'file_mime_type': 'fileMimeType',
        'file_url': 'fileUrl',
        'name': 'name',
        'service': 'service',
        'service_name': 'serviceName',
        'service_namespace': 'serviceNamespace',
        'service_vendor': 'serviceVendor'
    }

    def __init__(self, api_definition=None,api_name=None,api_namespace=None,api_vendor=None,file_mime_type=None,file_url=None,name=None,service=None,service_name=None,service_namespace=None,service_vendor=None):
        self._api_definition = None
        self._api_name = None
        self._api_namespace = None
        self._api_vendor = None
        self._file_mime_type = None
        self._file_url = None
        self._name = None
        self._service = None
        self._service_name = None
        self._service_namespace = None
        self._service_vendor = None

        if api_definition is not None:
            self.api_definition = api_definition
        if api_name is not None:
            self.api_name = api_name
        if api_namespace is not None:
            self.api_namespace = api_namespace
        if api_vendor is not None:
            self.api_vendor = api_vendor
        if file_mime_type is not None:
            self.file_mime_type = file_mime_type
        if file_url is not None:
            self.file_url = file_url
        if name is not None:
            self.name = name
        if service is not None:
            self.service = service
        if service_name is not None:
            self.service_name = service_name
        if service_namespace is not None:
            self.service_namespace = service_namespace
        if service_vendor is not None:
            self.service_vendor = service_vendor

    @property
    def api_definition(self):
        return self._api_definition
    
    @api_definition.setter
    def api_definition(self, api_definition):
        self._api_definition = api_definition

    @property
    def api_name(self):
        return self._api_name
    
    @api_name.setter
    def api_name(self, api_name):
        self._api_name = api_name

    @property
    def api_namespace(self):
        return self._api_namespace
    
    @api_namespace.setter
    def api_namespace(self, api_namespace):
        self._api_namespace = api_namespace

    @property
    def api_vendor(self):
        return self._api_vendor
    
    @api_vendor.setter
    def api_vendor(self, api_vendor):
        self._api_vendor = api_vendor

    @property
    def file_mime_type(self):
        return self._file_mime_type
    
    @file_mime_type.setter
    def file_mime_type(self, file_mime_type):
        self._file_mime_type = file_mime_type

    @property
    def file_url(self):
        return self._file_url
    
    @file_url.setter
    def file_url(self, file_url):
        self._file_url = file_url

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def service(self):
        return self._service
    
    @service.setter
    def service(self, service):
        self._service = service

    @property
    def service_name(self):
        return self._service_name
    
    @service_name.setter
    def service_name(self, service_name):
        self._service_name = service_name

    @property
    def service_namespace(self):
        return self._service_namespace
    
    @service_namespace.setter
    def service_namespace(self, service_namespace):
        self._service_namespace = service_namespace

    @property
    def service_vendor(self):
        return self._service_vendor
    
    @service_vendor.setter
    def service_vendor(self, service_vendor):
        self._service_vendor = service_vendor


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultFileDescriptorRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
