"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultEdgeGatewayRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'advanced_networking_enabled': 'bool',
        'available_net_count': 'int',
        'distributed_routing_enabled': 'bool',
        'gateway_status': 'str',
        'ha_status': 'str',
        'is_busy': 'bool',
        'name': 'str',
        'number_of_ext_networks': 'int',
        'number_of_org_networks': 'int',
        'org_vdc_name': 'str',
        'vdc': 'str'
    }

    attribute_map = {
        'advanced_networking_enabled': 'advancedNetworkingEnabled',
        'available_net_count': 'availableNetCount',
        'distributed_routing_enabled': 'distributedRoutingEnabled',
        'gateway_status': 'gatewayStatus',
        'ha_status': 'haStatus',
        'is_busy': 'isBusy',
        'name': 'name',
        'number_of_ext_networks': 'numberOfExtNetworks',
        'number_of_org_networks': 'numberOfOrgNetworks',
        'org_vdc_name': 'orgVdcName',
        'vdc': 'vdc'
    }

    def __init__(self, advanced_networking_enabled=None,available_net_count=None,distributed_routing_enabled=None,gateway_status=None,ha_status=None,is_busy=None,name=None,number_of_ext_networks=None,number_of_org_networks=None,org_vdc_name=None,vdc=None):
        self._advanced_networking_enabled = None
        self._available_net_count = None
        self._distributed_routing_enabled = None
        self._gateway_status = None
        self._ha_status = None
        self._is_busy = None
        self._name = None
        self._number_of_ext_networks = None
        self._number_of_org_networks = None
        self._org_vdc_name = None
        self._vdc = None

        if advanced_networking_enabled is not None:
            self.advanced_networking_enabled = advanced_networking_enabled
        if available_net_count is not None:
            self.available_net_count = available_net_count
        if distributed_routing_enabled is not None:
            self.distributed_routing_enabled = distributed_routing_enabled
        if gateway_status is not None:
            self.gateway_status = gateway_status
        if ha_status is not None:
            self.ha_status = ha_status
        if is_busy is not None:
            self.is_busy = is_busy
        if name is not None:
            self.name = name
        if number_of_ext_networks is not None:
            self.number_of_ext_networks = number_of_ext_networks
        if number_of_org_networks is not None:
            self.number_of_org_networks = number_of_org_networks
        if org_vdc_name is not None:
            self.org_vdc_name = org_vdc_name
        if vdc is not None:
            self.vdc = vdc

    @property
    def advanced_networking_enabled(self):
        return self._advanced_networking_enabled
    
    @advanced_networking_enabled.setter
    def advanced_networking_enabled(self, advanced_networking_enabled):
        self._advanced_networking_enabled = advanced_networking_enabled

    @property
    def available_net_count(self):
        return self._available_net_count
    
    @available_net_count.setter
    def available_net_count(self, available_net_count):
        self._available_net_count = available_net_count

    @property
    def distributed_routing_enabled(self):
        return self._distributed_routing_enabled
    
    @distributed_routing_enabled.setter
    def distributed_routing_enabled(self, distributed_routing_enabled):
        self._distributed_routing_enabled = distributed_routing_enabled

    @property
    def gateway_status(self):
        return self._gateway_status
    
    @gateway_status.setter
    def gateway_status(self, gateway_status):
        self._gateway_status = gateway_status

    @property
    def ha_status(self):
        return self._ha_status
    
    @ha_status.setter
    def ha_status(self, ha_status):
        self._ha_status = ha_status

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def number_of_ext_networks(self):
        return self._number_of_ext_networks
    
    @number_of_ext_networks.setter
    def number_of_ext_networks(self, number_of_ext_networks):
        self._number_of_ext_networks = number_of_ext_networks

    @property
    def number_of_org_networks(self):
        return self._number_of_org_networks
    
    @number_of_org_networks.setter
    def number_of_org_networks(self, number_of_org_networks):
        self._number_of_org_networks = number_of_org_networks

    @property
    def org_vdc_name(self):
        return self._org_vdc_name
    
    @org_vdc_name.setter
    def org_vdc_name(self, org_vdc_name):
        self._org_vdc_name = org_vdc_name

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultEdgeGatewayRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
