"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAdminOrgVdcStorageProfileRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'iops_allocated': 'int',
        'iops_limit': 'int',
        'is_default_storage_profile': 'bool',
        'is_enabled': 'bool',
        'name': 'str',
        'number_of_conditions': 'int',
        'org': 'str',
        'storage_limit_mb': 'int',
        'storage_profile_moref': 'str',
        'storage_used_mb': 'int',
        'vc': 'str',
        'vdc': 'str',
        'vdc_name': 'str'
    }

    attribute_map = {
        'iops_allocated': 'iopsAllocated',
        'iops_limit': 'iopsLimit',
        'is_default_storage_profile': 'isDefaultStorageProfile',
        'is_enabled': 'isEnabled',
        'name': 'name',
        'number_of_conditions': 'numberOfConditions',
        'org': 'org',
        'storage_limit_mb': 'storageLimitMB',
        'storage_profile_moref': 'storageProfileMoref',
        'storage_used_mb': 'storageUsedMB',
        'vc': 'vc',
        'vdc': 'vdc',
        'vdc_name': 'vdcName'
    }

    def __init__(self, iops_allocated=None,iops_limit=None,is_default_storage_profile=None,is_enabled=None,name=None,number_of_conditions=None,org=None,storage_limit_mb=None,storage_profile_moref=None,storage_used_mb=None,vc=None,vdc=None,vdc_name=None):
        self._iops_allocated = None
        self._iops_limit = None
        self._is_default_storage_profile = None
        self._is_enabled = None
        self._name = None
        self._number_of_conditions = None
        self._org = None
        self._storage_limit_mb = None
        self._storage_profile_moref = None
        self._storage_used_mb = None
        self._vc = None
        self._vdc = None
        self._vdc_name = None

        if iops_allocated is not None:
            self.iops_allocated = iops_allocated
        if iops_limit is not None:
            self.iops_limit = iops_limit
        if is_default_storage_profile is not None:
            self.is_default_storage_profile = is_default_storage_profile
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if name is not None:
            self.name = name
        if number_of_conditions is not None:
            self.number_of_conditions = number_of_conditions
        if org is not None:
            self.org = org
        if storage_limit_mb is not None:
            self.storage_limit_mb = storage_limit_mb
        if storage_profile_moref is not None:
            self.storage_profile_moref = storage_profile_moref
        if storage_used_mb is not None:
            self.storage_used_mb = storage_used_mb
        if vc is not None:
            self.vc = vc
        if vdc is not None:
            self.vdc = vdc
        if vdc_name is not None:
            self.vdc_name = vdc_name

    @property
    def iops_allocated(self):
        return self._iops_allocated
    
    @iops_allocated.setter
    def iops_allocated(self, iops_allocated):
        self._iops_allocated = iops_allocated

    @property
    def iops_limit(self):
        return self._iops_limit
    
    @iops_limit.setter
    def iops_limit(self, iops_limit):
        self._iops_limit = iops_limit

    @property
    def is_default_storage_profile(self):
        return self._is_default_storage_profile
    
    @is_default_storage_profile.setter
    def is_default_storage_profile(self, is_default_storage_profile):
        self._is_default_storage_profile = is_default_storage_profile

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def number_of_conditions(self):
        return self._number_of_conditions
    
    @number_of_conditions.setter
    def number_of_conditions(self, number_of_conditions):
        self._number_of_conditions = number_of_conditions

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def storage_limit_mb(self):
        return self._storage_limit_mb
    
    @storage_limit_mb.setter
    def storage_limit_mb(self, storage_limit_mb):
        self._storage_limit_mb = storage_limit_mb

    @property
    def storage_profile_moref(self):
        return self._storage_profile_moref
    
    @storage_profile_moref.setter
    def storage_profile_moref(self, storage_profile_moref):
        self._storage_profile_moref = storage_profile_moref

    @property
    def storage_used_mb(self):
        return self._storage_used_mb
    
    @storage_used_mb.setter
    def storage_used_mb(self, storage_used_mb):
        self._storage_used_mb = storage_used_mb

    @property
    def vc(self):
        return self._vc
    
    @vc.setter
    def vc(self, vc):
        self._vc = vc

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc

    @property
    def vdc_name(self):
        return self._vdc_name
    
    @vdc_name.setter
    def vdc_name(self, vdc_name):
        self._vdc_name = vdc_name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAdminOrgVdcStorageProfileRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
