"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAdminDiskRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bus_sub_type': 'str',
        'bus_type': 'str',
        'bus_type_desc': 'str',
        'datastore': 'str',
        'datastore_name': 'str',
        'is_attached': 'bool',
        'name': 'str',
        'org': 'str',
        'owner_name': 'str',
        'size_b': 'int',
        'status': 'str',
        'storage_profile': 'str',
        'storage_profile_name': 'str',
        'task': 'str',
        'vc': 'str',
        'vdc': 'str',
        'vdc_name': 'str'
    }

    attribute_map = {
        'bus_sub_type': 'busSubType',
        'bus_type': 'busType',
        'bus_type_desc': 'busTypeDesc',
        'datastore': 'datastore',
        'datastore_name': 'datastoreName',
        'is_attached': 'isAttached',
        'name': 'name',
        'org': 'org',
        'owner_name': 'ownerName',
        'size_b': 'sizeB',
        'status': 'status',
        'storage_profile': 'storageProfile',
        'storage_profile_name': 'storageProfileName',
        'task': 'task',
        'vc': 'vc',
        'vdc': 'vdc',
        'vdc_name': 'vdcName'
    }

    def __init__(self, bus_sub_type=None,bus_type=None,bus_type_desc=None,datastore=None,datastore_name=None,is_attached=None,name=None,org=None,owner_name=None,size_b=None,status=None,storage_profile=None,storage_profile_name=None,task=None,vc=None,vdc=None,vdc_name=None):
        self._bus_sub_type = None
        self._bus_type = None
        self._bus_type_desc = None
        self._datastore = None
        self._datastore_name = None
        self._is_attached = None
        self._name = None
        self._org = None
        self._owner_name = None
        self._size_b = None
        self._status = None
        self._storage_profile = None
        self._storage_profile_name = None
        self._task = None
        self._vc = None
        self._vdc = None
        self._vdc_name = None

        if bus_sub_type is not None:
            self.bus_sub_type = bus_sub_type
        if bus_type is not None:
            self.bus_type = bus_type
        if bus_type_desc is not None:
            self.bus_type_desc = bus_type_desc
        if datastore is not None:
            self.datastore = datastore
        if datastore_name is not None:
            self.datastore_name = datastore_name
        if is_attached is not None:
            self.is_attached = is_attached
        if name is not None:
            self.name = name
        if org is not None:
            self.org = org
        if owner_name is not None:
            self.owner_name = owner_name
        if size_b is not None:
            self.size_b = size_b
        if status is not None:
            self.status = status
        if storage_profile is not None:
            self.storage_profile = storage_profile
        if storage_profile_name is not None:
            self.storage_profile_name = storage_profile_name
        if task is not None:
            self.task = task
        if vc is not None:
            self.vc = vc
        if vdc is not None:
            self.vdc = vdc
        if vdc_name is not None:
            self.vdc_name = vdc_name

    @property
    def bus_sub_type(self):
        return self._bus_sub_type
    
    @bus_sub_type.setter
    def bus_sub_type(self, bus_sub_type):
        self._bus_sub_type = bus_sub_type

    @property
    def bus_type(self):
        return self._bus_type
    
    @bus_type.setter
    def bus_type(self, bus_type):
        self._bus_type = bus_type

    @property
    def bus_type_desc(self):
        return self._bus_type_desc
    
    @bus_type_desc.setter
    def bus_type_desc(self, bus_type_desc):
        self._bus_type_desc = bus_type_desc

    @property
    def datastore(self):
        return self._datastore
    
    @datastore.setter
    def datastore(self, datastore):
        self._datastore = datastore

    @property
    def datastore_name(self):
        return self._datastore_name
    
    @datastore_name.setter
    def datastore_name(self, datastore_name):
        self._datastore_name = datastore_name

    @property
    def is_attached(self):
        return self._is_attached
    
    @is_attached.setter
    def is_attached(self, is_attached):
        self._is_attached = is_attached

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def owner_name(self):
        return self._owner_name
    
    @owner_name.setter
    def owner_name(self, owner_name):
        self._owner_name = owner_name

    @property
    def size_b(self):
        return self._size_b
    
    @size_b.setter
    def size_b(self, size_b):
        self._size_b = size_b

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def storage_profile(self):
        return self._storage_profile
    
    @storage_profile.setter
    def storage_profile(self, storage_profile):
        self._storage_profile = storage_profile

    @property
    def storage_profile_name(self):
        return self._storage_profile_name
    
    @storage_profile_name.setter
    def storage_profile_name(self, storage_profile_name):
        self._storage_profile_name = storage_profile_name

    @property
    def task(self):
        return self._task
    
    @task.setter
    def task(self, task):
        self._task = task

    @property
    def vc(self):
        return self._vc
    
    @vc.setter
    def vc(self, vc):
        self._vc = vc

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc

    @property
    def vdc_name(self):
        return self._vdc_name
    
    @vdc_name.setter
    def vdc_name(self, vdc_name):
        self._vdc_name = vdc_name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAdminDiskRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
