"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAdminCatalogRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'creation_date': 'str',
        'is_published': 'bool',
        'is_shared': 'bool',
        'name': 'str',
        'number_of_media': 'int',
        'number_of_templates': 'int',
        'org': 'str',
        'org_name': 'str',
        'owner': 'str',
        'owner_name': 'str'
    }

    attribute_map = {
        'creation_date': 'creationDate',
        'is_published': 'isPublished',
        'is_shared': 'isShared',
        'name': 'name',
        'number_of_media': 'numberOfMedia',
        'number_of_templates': 'numberOfTemplates',
        'org': 'org',
        'org_name': 'orgName',
        'owner': 'owner',
        'owner_name': 'ownerName'
    }

    def __init__(self, creation_date=None,is_published=None,is_shared=None,name=None,number_of_media=None,number_of_templates=None,org=None,org_name=None,owner=None,owner_name=None):
        self._creation_date = None
        self._is_published = None
        self._is_shared = None
        self._name = None
        self._number_of_media = None
        self._number_of_templates = None
        self._org = None
        self._org_name = None
        self._owner = None
        self._owner_name = None

        if creation_date is not None:
            self.creation_date = creation_date
        if is_published is not None:
            self.is_published = is_published
        if is_shared is not None:
            self.is_shared = is_shared
        if name is not None:
            self.name = name
        if number_of_media is not None:
            self.number_of_media = number_of_media
        if number_of_templates is not None:
            self.number_of_templates = number_of_templates
        if org is not None:
            self.org = org
        if org_name is not None:
            self.org_name = org_name
        if owner is not None:
            self.owner = owner
        if owner_name is not None:
            self.owner_name = owner_name

    @property
    def creation_date(self):
        return self._creation_date
    
    @creation_date.setter
    def creation_date(self, creation_date):
        self._creation_date = creation_date

    @property
    def is_published(self):
        return self._is_published
    
    @is_published.setter
    def is_published(self, is_published):
        self._is_published = is_published

    @property
    def is_shared(self):
        return self._is_shared
    
    @is_shared.setter
    def is_shared(self, is_shared):
        self._is_shared = is_shared

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def number_of_media(self):
        return self._number_of_media
    
    @number_of_media.setter
    def number_of_media(self, number_of_media):
        self._number_of_media = number_of_media

    @property
    def number_of_templates(self):
        return self._number_of_templates
    
    @number_of_templates.setter
    def number_of_templates(self, number_of_templates):
        self._number_of_templates = number_of_templates

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def org_name(self):
        return self._org_name
    
    @org_name.setter
    def org_name(self, org_name):
        self._org_name = org_name

    @property
    def owner(self):
        return self._owner
    
    @owner.setter
    def owner(self, owner):
        self._owner = owner

    @property
    def owner_name(self):
        return self._owner_name
    
    @owner_name.setter
    def owner_name(self, owner_name):
        self._owner_name = owner_name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAdminCatalogRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
