"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .network_type import NetworkType


class OrgNetworkType(NetworkType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'network_pool': 'ReferenceType',
        'allowed_external_ip_addresses': 'IpAddressesType'
    }

    attribute_map = {
        'network_pool': 'networkPool',
        'allowed_external_ip_addresses': 'allowedExternalIpAddresses'
    }

    def __init__(self, network_pool=None,allowed_external_ip_addresses=None):
        self._network_pool = None
        self._allowed_external_ip_addresses = None

        if network_pool is not None:
            self.network_pool = network_pool
        if allowed_external_ip_addresses is not None:
            self.allowed_external_ip_addresses = allowed_external_ip_addresses

    @property
    def network_pool(self):
        return self._network_pool
    
    @network_pool.setter
    def network_pool(self, network_pool):
        self._network_pool = network_pool

    @property
    def allowed_external_ip_addresses(self):
        return self._allowed_external_ip_addresses
    
    @allowed_external_ip_addresses.setter
    def allowed_external_ip_addresses(self, allowed_external_ip_addresses):
        self._allowed_external_ip_addresses = allowed_external_ip_addresses


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrgNetworkType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
