"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class OrgGuestPersonalizationSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'domain_username': 'str',
        'domain_password': 'str',
        'domain_name': 'str',
        'allow_domain_settings': 'bool',
        'account_organizational_unit': 'str'
    }

    attribute_map = {
        'domain_username': 'domainUsername',
        'domain_password': 'domainPassword',
        'domain_name': 'domainName',
        'allow_domain_settings': 'allowDomainSettings',
        'account_organizational_unit': 'accountOrganizationalUnit'
    }

    def __init__(self, domain_username=None,domain_password=None,domain_name=None,allow_domain_settings=None,account_organizational_unit=None):
        self._domain_username = None
        self._domain_password = None
        self._domain_name = None
        self._allow_domain_settings = None
        self._account_organizational_unit = None

        if domain_username is not None:
            self.domain_username = domain_username
        if domain_password is not None:
            self.domain_password = domain_password
        if domain_name is not None:
            self.domain_name = domain_name
        if allow_domain_settings is not None:
            self.allow_domain_settings = allow_domain_settings
        if account_organizational_unit is not None:
            self.account_organizational_unit = account_organizational_unit

    @property
    def domain_username(self):
        return self._domain_username
    
    @domain_username.setter
    def domain_username(self, domain_username):
        self._domain_username = domain_username

    @property
    def domain_password(self):
        return self._domain_password
    
    @domain_password.setter
    def domain_password(self, domain_password):
        self._domain_password = domain_password

    @property
    def domain_name(self):
        return self._domain_name
    
    @domain_name.setter
    def domain_name(self, domain_name):
        self._domain_name = domain_name

    @property
    def allow_domain_settings(self):
        return self._allow_domain_settings
    
    @allow_domain_settings.setter
    def allow_domain_settings(self, allow_domain_settings):
        self._allow_domain_settings = allow_domain_settings

    @property
    def account_organizational_unit(self):
        return self._account_organizational_unit
    
    @account_organizational_unit.setter
    def account_organizational_unit(self, account_organizational_unit):
        self._account_organizational_unit = account_organizational_unit


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrgGuestPersonalizationSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
