"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class OrgFederationSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'saml_metadata': 'str',
        'enabled': 'bool',
        'certificate_expiration': 'str',
        'saml_sp_entity_id': 'str',
        'role_attribute_name': 'str',
        'saml_attribute_mapping': 'SamlAttributeMappingType',
        'saml_sp_key_and_certificate_chain': 'SamlSPKeyAndCertificateChainType'
    }

    attribute_map = {
        'saml_metadata': 'samlMetadata',
        'enabled': 'enabled',
        'certificate_expiration': 'certificateExpiration',
        'saml_sp_entity_id': 'samlSPEntityId',
        'role_attribute_name': 'roleAttributeName',
        'saml_attribute_mapping': 'samlAttributeMapping',
        'saml_sp_key_and_certificate_chain': 'samlSPKeyAndCertificateChain'
    }

    def __init__(self, saml_metadata=None,enabled=None,certificate_expiration=None,saml_sp_entity_id=None,role_attribute_name=None,saml_attribute_mapping=None,saml_sp_key_and_certificate_chain=None):
        self._saml_metadata = None
        self._enabled = None
        self._certificate_expiration = None
        self._saml_sp_entity_id = None
        self._role_attribute_name = None
        self._saml_attribute_mapping = None
        self._saml_sp_key_and_certificate_chain = None

        if saml_metadata is not None:
            self.saml_metadata = saml_metadata
        if enabled is not None:
            self.enabled = enabled
        if certificate_expiration is not None:
            self.certificate_expiration = certificate_expiration
        if saml_sp_entity_id is not None:
            self.saml_sp_entity_id = saml_sp_entity_id
        if role_attribute_name is not None:
            self.role_attribute_name = role_attribute_name
        if saml_attribute_mapping is not None:
            self.saml_attribute_mapping = saml_attribute_mapping
        if saml_sp_key_and_certificate_chain is not None:
            self.saml_sp_key_and_certificate_chain = saml_sp_key_and_certificate_chain

    @property
    def saml_metadata(self):
        return self._saml_metadata
    
    @saml_metadata.setter
    def saml_metadata(self, saml_metadata):
        self._saml_metadata = saml_metadata

    @property
    def enabled(self):
        return self._enabled
    
    @enabled.setter
    def enabled(self, enabled):
        self._enabled = enabled

    @property
    def certificate_expiration(self):
        return self._certificate_expiration
    
    @certificate_expiration.setter
    def certificate_expiration(self, certificate_expiration):
        self._certificate_expiration = certificate_expiration

    @property
    def saml_sp_entity_id(self):
        return self._saml_sp_entity_id
    
    @saml_sp_entity_id.setter
    def saml_sp_entity_id(self, saml_sp_entity_id):
        self._saml_sp_entity_id = saml_sp_entity_id

    @property
    def role_attribute_name(self):
        return self._role_attribute_name
    
    @role_attribute_name.setter
    def role_attribute_name(self, role_attribute_name):
        self._role_attribute_name = role_attribute_name

    @property
    def saml_attribute_mapping(self):
        return self._saml_attribute_mapping
    
    @saml_attribute_mapping.setter
    def saml_attribute_mapping(self, saml_attribute_mapping):
        self._saml_attribute_mapping = saml_attribute_mapping

    @property
    def saml_sp_key_and_certificate_chain(self):
        return self._saml_sp_key_and_certificate_chain
    
    @saml_sp_key_and_certificate_chain.setter
    def saml_sp_key_and_certificate_chain(self, saml_sp_key_and_certificate_chain):
        self._saml_sp_key_and_certificate_chain = saml_sp_key_and_certificate_chain


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrgFederationSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
