"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class NetworkConnectionType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'network_connection_index': 'int',
        'ip_address': 'str',
        'external_ip_address': 'str',
        'is_connected': 'bool',
        'mac_address': 'str',
        'ip_address_allocation_mode': 'str',
        'network_adapter_type': 'str',
        'needs_customization': 'bool',
        'network': 'str'
    }

    attribute_map = {
        'network_connection_index': 'networkConnectionIndex',
        'ip_address': 'ipAddress',
        'external_ip_address': 'externalIpAddress',
        'is_connected': 'isConnected',
        'mac_address': 'macAddress',
        'ip_address_allocation_mode': 'ipAddressAllocationMode',
        'network_adapter_type': 'networkAdapterType',
        'needs_customization': 'needsCustomization',
        'network': 'network'
    }

    def __init__(self, network_connection_index=None,ip_address=None,external_ip_address=None,is_connected=None,mac_address=None,ip_address_allocation_mode=None,network_adapter_type=None,needs_customization=None,network=None):
        self._network_connection_index = None
        self._ip_address = None
        self._external_ip_address = None
        self._is_connected = None
        self._mac_address = None
        self._ip_address_allocation_mode = None
        self._network_adapter_type = None
        self._needs_customization = None
        self._network = None

        if network_connection_index is not None:
            self.network_connection_index = network_connection_index
        if ip_address is not None:
            self.ip_address = ip_address
        if external_ip_address is not None:
            self.external_ip_address = external_ip_address
        if is_connected is not None:
            self.is_connected = is_connected
        if mac_address is not None:
            self.mac_address = mac_address
        if ip_address_allocation_mode is not None:
            self.ip_address_allocation_mode = ip_address_allocation_mode
        if network_adapter_type is not None:
            self.network_adapter_type = network_adapter_type
        if needs_customization is not None:
            self.needs_customization = needs_customization
        if network is not None:
            self.network = network

    @property
    def network_connection_index(self):
        return self._network_connection_index
    
    @network_connection_index.setter
    def network_connection_index(self, network_connection_index):
        self._network_connection_index = network_connection_index

    @property
    def ip_address(self):
        return self._ip_address
    
    @ip_address.setter
    def ip_address(self, ip_address):
        self._ip_address = ip_address

    @property
    def external_ip_address(self):
        return self._external_ip_address
    
    @external_ip_address.setter
    def external_ip_address(self, external_ip_address):
        self._external_ip_address = external_ip_address

    @property
    def is_connected(self):
        return self._is_connected
    
    @is_connected.setter
    def is_connected(self, is_connected):
        self._is_connected = is_connected

    @property
    def mac_address(self):
        return self._mac_address
    
    @mac_address.setter
    def mac_address(self, mac_address):
        self._mac_address = mac_address

    @property
    def ip_address_allocation_mode(self):
        return self._ip_address_allocation_mode
    
    @ip_address_allocation_mode.setter
    def ip_address_allocation_mode(self, ip_address_allocation_mode):
        self._ip_address_allocation_mode = ip_address_allocation_mode

    @property
    def network_adapter_type(self):
        return self._network_adapter_type
    
    @network_adapter_type.setter
    def network_adapter_type(self, network_adapter_type):
        self._network_adapter_type = network_adapter_type

    @property
    def needs_customization(self):
        return self._needs_customization
    
    @needs_customization.setter
    def needs_customization(self, needs_customization):
        self._needs_customization = needs_customization

    @property
    def network(self):
        return self._network
    
    @network.setter
    def network(self, network):
        self._network = network


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetworkConnectionType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
