"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class NetworkConfigurationType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'backward_compatibility_mode': 'bool',
        'ip_scope': 'IpScopeType',
        'ip_scopes': 'IpScopesType',
        'parent_network': 'ReferenceType',
        'fence_mode': 'str',
        'retain_net_info_across_deployments': 'bool',
        'features': 'NetworkFeaturesType',
        'syslog_server_settings': 'SyslogServerSettingsType',
        'router_info': 'RouterInfoType',
        'advanced_networking_enabled': 'bool',
        'sub_interface': 'bool',
        'distributed_interface': 'bool',
        'guest_vlan_allowed': 'bool',
        'connected': 'bool'
    }

    attribute_map = {
        'backward_compatibility_mode': 'backwardCompatibilityMode',
        'ip_scope': 'ipScope',
        'ip_scopes': 'ipScopes',
        'parent_network': 'parentNetwork',
        'fence_mode': 'fenceMode',
        'retain_net_info_across_deployments': 'retainNetInfoAcrossDeployments',
        'features': 'features',
        'syslog_server_settings': 'syslogServerSettings',
        'router_info': 'routerInfo',
        'advanced_networking_enabled': 'advancedNetworkingEnabled',
        'sub_interface': 'subInterface',
        'distributed_interface': 'distributedInterface',
        'guest_vlan_allowed': 'guestVlanAllowed',
        'connected': 'connected'
    }

    def __init__(self, backward_compatibility_mode=None,ip_scope=None,ip_scopes=None,parent_network=None,fence_mode=None,retain_net_info_across_deployments=None,features=None,syslog_server_settings=None,router_info=None,advanced_networking_enabled=None,sub_interface=None,distributed_interface=None,guest_vlan_allowed=None,connected=None):
        self._backward_compatibility_mode = None
        self._ip_scope = None
        self._ip_scopes = None
        self._parent_network = None
        self._fence_mode = None
        self._retain_net_info_across_deployments = None
        self._features = None
        self._syslog_server_settings = None
        self._router_info = None
        self._advanced_networking_enabled = None
        self._sub_interface = None
        self._distributed_interface = None
        self._guest_vlan_allowed = None
        self._connected = None

        if backward_compatibility_mode is not None:
            self.backward_compatibility_mode = backward_compatibility_mode
        if ip_scope is not None:
            self.ip_scope = ip_scope
        if ip_scopes is not None:
            self.ip_scopes = ip_scopes
        if parent_network is not None:
            self.parent_network = parent_network
        if fence_mode is not None:
            self.fence_mode = fence_mode
        if retain_net_info_across_deployments is not None:
            self.retain_net_info_across_deployments = retain_net_info_across_deployments
        if features is not None:
            self.features = features
        if syslog_server_settings is not None:
            self.syslog_server_settings = syslog_server_settings
        if router_info is not None:
            self.router_info = router_info
        if advanced_networking_enabled is not None:
            self.advanced_networking_enabled = advanced_networking_enabled
        if sub_interface is not None:
            self.sub_interface = sub_interface
        if distributed_interface is not None:
            self.distributed_interface = distributed_interface
        if guest_vlan_allowed is not None:
            self.guest_vlan_allowed = guest_vlan_allowed
        if connected is not None:
            self.connected = connected

    @property
    def backward_compatibility_mode(self):
        return self._backward_compatibility_mode
    
    @backward_compatibility_mode.setter
    def backward_compatibility_mode(self, backward_compatibility_mode):
        self._backward_compatibility_mode = backward_compatibility_mode

    @property
    def ip_scope(self):
        return self._ip_scope
    
    @ip_scope.setter
    def ip_scope(self, ip_scope):
        self._ip_scope = ip_scope

    @property
    def ip_scopes(self):
        return self._ip_scopes
    
    @ip_scopes.setter
    def ip_scopes(self, ip_scopes):
        self._ip_scopes = ip_scopes

    @property
    def parent_network(self):
        return self._parent_network
    
    @parent_network.setter
    def parent_network(self, parent_network):
        self._parent_network = parent_network

    @property
    def fence_mode(self):
        return self._fence_mode
    
    @fence_mode.setter
    def fence_mode(self, fence_mode):
        self._fence_mode = fence_mode

    @property
    def retain_net_info_across_deployments(self):
        return self._retain_net_info_across_deployments
    
    @retain_net_info_across_deployments.setter
    def retain_net_info_across_deployments(self, retain_net_info_across_deployments):
        self._retain_net_info_across_deployments = retain_net_info_across_deployments

    @property
    def features(self):
        return self._features
    
    @features.setter
    def features(self, features):
        self._features = features

    @property
    def syslog_server_settings(self):
        return self._syslog_server_settings
    
    @syslog_server_settings.setter
    def syslog_server_settings(self, syslog_server_settings):
        self._syslog_server_settings = syslog_server_settings

    @property
    def router_info(self):
        return self._router_info
    
    @router_info.setter
    def router_info(self, router_info):
        self._router_info = router_info

    @property
    def advanced_networking_enabled(self):
        return self._advanced_networking_enabled
    
    @advanced_networking_enabled.setter
    def advanced_networking_enabled(self, advanced_networking_enabled):
        self._advanced_networking_enabled = advanced_networking_enabled

    @property
    def sub_interface(self):
        return self._sub_interface
    
    @sub_interface.setter
    def sub_interface(self, sub_interface):
        self._sub_interface = sub_interface

    @property
    def distributed_interface(self):
        return self._distributed_interface
    
    @distributed_interface.setter
    def distributed_interface(self, distributed_interface):
        self._distributed_interface = distributed_interface

    @property
    def guest_vlan_allowed(self):
        return self._guest_vlan_allowed
    
    @guest_vlan_allowed.setter
    def guest_vlan_allowed(self, guest_vlan_allowed):
        self._guest_vlan_allowed = guest_vlan_allowed

    @property
    def connected(self):
        return self._connected
    
    @connected.setter
    def connected(self, connected):
        self._connected = connected


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetworkConfigurationType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
