"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class LBVirtualServerServiceProfileType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_enabled': 'bool',
        'protocol': 'str',
        'port': 'str',
        'persistence': 'LBPersistenceType'
    }

    attribute_map = {
        'is_enabled': 'isEnabled',
        'protocol': 'protocol',
        'port': 'port',
        'persistence': 'persistence'
    }

    def __init__(self, is_enabled=None,protocol=None,port=None,persistence=None):
        self._is_enabled = None
        self._protocol = None
        self._port = None
        self._persistence = None

        if is_enabled is not None:
            self.is_enabled = is_enabled
        if protocol is not None:
            self.protocol = protocol
        if port is not None:
            self.port = port
        if persistence is not None:
            self.persistence = persistence

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def protocol(self):
        return self._protocol
    
    @protocol.setter
    def protocol(self, protocol):
        self._protocol = protocol

    @property
    def port(self):
        return self._port
    
    @port.setter
    def port(self, port):
        self._port = port

    @property
    def persistence(self):
        return self._persistence
    
    @persistence.setter
    def persistence(self, persistence):
        self._persistence = persistence


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LBVirtualServerServiceProfileType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
