"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class InstantiateVmParamsType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'network_connection_section': 'NetworkConnectionSectionType',
        'computer_name': 'str',
        'vdc_storage_profile': 'ReferenceType',
        'hardware_customization': 'InstantiateVmHardwareCustomizationParamsType',
        'id': 'str'
    }

    attribute_map = {
        'network_connection_section': 'networkConnectionSection',
        'computer_name': 'computerName',
        'vdc_storage_profile': 'vdcStorageProfile',
        'hardware_customization': 'hardwareCustomization',
        'id': 'id'
    }

    def __init__(self, network_connection_section=None,computer_name=None,vdc_storage_profile=None,hardware_customization=None,id=None):
        self._network_connection_section = None
        self._computer_name = None
        self._vdc_storage_profile = None
        self._hardware_customization = None
        self._id = None

        if network_connection_section is not None:
            self.network_connection_section = network_connection_section
        if computer_name is not None:
            self.computer_name = computer_name
        if vdc_storage_profile is not None:
            self.vdc_storage_profile = vdc_storage_profile
        if hardware_customization is not None:
            self.hardware_customization = hardware_customization
        if id is not None:
            self.id = id

    @property
    def network_connection_section(self):
        return self._network_connection_section
    
    @network_connection_section.setter
    def network_connection_section(self, network_connection_section):
        self._network_connection_section = network_connection_section

    @property
    def computer_name(self):
        return self._computer_name
    
    @computer_name.setter
    def computer_name(self, computer_name):
        self._computer_name = computer_name

    @property
    def vdc_storage_profile(self):
        return self._vdc_storage_profile
    
    @vdc_storage_profile.setter
    def vdc_storage_profile(self, vdc_storage_profile):
        self._vdc_storage_profile = vdc_storage_profile

    @property
    def hardware_customization(self):
        return self._hardware_customization
    
    @hardware_customization.setter
    def hardware_customization(self, hardware_customization):
        self._hardware_customization = hardware_customization

    @property
    def id(self):
        return self._id
    
    @id.setter
    def id(self, id):
        self._id = id


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InstantiateVmParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
