"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..schema.ovf.section_type import SectionType


class GuestCustomizationSectionType(SectionType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'enabled': 'bool',
        'change_sid': 'bool',
        'virtual_machine_id': 'str',
        'join_domain_enabled': 'bool',
        'use_org_settings': 'bool',
        'domain_name': 'str',
        'domain_user_name': 'str',
        'domain_user_password': 'str',
        'machine_object_ou': 'str',
        'admin_password_enabled': 'bool',
        'admin_password_auto': 'bool',
        'admin_password': 'str',
        'admin_auto_logon_enabled': 'bool',
        'admin_auto_logon_count': 'int',
        'reset_password_required': 'bool',
        'customization_script': 'str',
        'computer_name': 'str',
        'link': 'list[LinkType]',
        'any': 'list[object]',
        'href': 'str',
        'type': 'str'
    }

    attribute_map = {
        'enabled': 'enabled',
        'change_sid': 'changeSid',
        'virtual_machine_id': 'virtualMachineId',
        'join_domain_enabled': 'joinDomainEnabled',
        'use_org_settings': 'useOrgSettings',
        'domain_name': 'domainName',
        'domain_user_name': 'domainUserName',
        'domain_user_password': 'domainUserPassword',
        'machine_object_ou': 'machineObjectOU',
        'admin_password_enabled': 'adminPasswordEnabled',
        'admin_password_auto': 'adminPasswordAuto',
        'admin_password': 'adminPassword',
        'admin_auto_logon_enabled': 'adminAutoLogonEnabled',
        'admin_auto_logon_count': 'adminAutoLogonCount',
        'reset_password_required': 'resetPasswordRequired',
        'customization_script': 'customizationScript',
        'computer_name': 'computerName',
        'link': 'link',
        'any': 'any',
        'href': 'href',
        'type': 'type'
    }

    def __init__(self, enabled=None,change_sid=None,virtual_machine_id=None,join_domain_enabled=None,use_org_settings=None,domain_name=None,domain_user_name=None,domain_user_password=None,machine_object_ou=None,admin_password_enabled=None,admin_password_auto=None,admin_password=None,admin_auto_logon_enabled=None,admin_auto_logon_count=None,reset_password_required=None,customization_script=None,computer_name=None,link=None,any=None,href=None,type=None):
        self._enabled = None
        self._change_sid = None
        self._virtual_machine_id = None
        self._join_domain_enabled = None
        self._use_org_settings = None
        self._domain_name = None
        self._domain_user_name = None
        self._domain_user_password = None
        self._machine_object_ou = None
        self._admin_password_enabled = None
        self._admin_password_auto = None
        self._admin_password = None
        self._admin_auto_logon_enabled = None
        self._admin_auto_logon_count = None
        self._reset_password_required = None
        self._customization_script = None
        self._computer_name = None
        self._link = None
        self._any = None
        self._href = None
        self._type = None

        if enabled is not None:
            self.enabled = enabled
        if change_sid is not None:
            self.change_sid = change_sid
        if virtual_machine_id is not None:
            self.virtual_machine_id = virtual_machine_id
        if join_domain_enabled is not None:
            self.join_domain_enabled = join_domain_enabled
        if use_org_settings is not None:
            self.use_org_settings = use_org_settings
        if domain_name is not None:
            self.domain_name = domain_name
        if domain_user_name is not None:
            self.domain_user_name = domain_user_name
        if domain_user_password is not None:
            self.domain_user_password = domain_user_password
        if machine_object_ou is not None:
            self.machine_object_ou = machine_object_ou
        if admin_password_enabled is not None:
            self.admin_password_enabled = admin_password_enabled
        if admin_password_auto is not None:
            self.admin_password_auto = admin_password_auto
        if admin_password is not None:
            self.admin_password = admin_password
        if admin_auto_logon_enabled is not None:
            self.admin_auto_logon_enabled = admin_auto_logon_enabled
        if admin_auto_logon_count is not None:
            self.admin_auto_logon_count = admin_auto_logon_count
        if reset_password_required is not None:
            self.reset_password_required = reset_password_required
        if customization_script is not None:
            self.customization_script = customization_script
        if computer_name is not None:
            self.computer_name = computer_name
        if link is not None:
            self.link = link
        if any is not None:
            self.any = any
        if href is not None:
            self.href = href
        if type is not None:
            self.type = type

    @property
    def enabled(self):
        return self._enabled
    
    @enabled.setter
    def enabled(self, enabled):
        self._enabled = enabled

    @property
    def change_sid(self):
        return self._change_sid
    
    @change_sid.setter
    def change_sid(self, change_sid):
        self._change_sid = change_sid

    @property
    def virtual_machine_id(self):
        return self._virtual_machine_id
    
    @virtual_machine_id.setter
    def virtual_machine_id(self, virtual_machine_id):
        self._virtual_machine_id = virtual_machine_id

    @property
    def join_domain_enabled(self):
        return self._join_domain_enabled
    
    @join_domain_enabled.setter
    def join_domain_enabled(self, join_domain_enabled):
        self._join_domain_enabled = join_domain_enabled

    @property
    def use_org_settings(self):
        return self._use_org_settings
    
    @use_org_settings.setter
    def use_org_settings(self, use_org_settings):
        self._use_org_settings = use_org_settings

    @property
    def domain_name(self):
        return self._domain_name
    
    @domain_name.setter
    def domain_name(self, domain_name):
        self._domain_name = domain_name

    @property
    def domain_user_name(self):
        return self._domain_user_name
    
    @domain_user_name.setter
    def domain_user_name(self, domain_user_name):
        self._domain_user_name = domain_user_name

    @property
    def domain_user_password(self):
        return self._domain_user_password
    
    @domain_user_password.setter
    def domain_user_password(self, domain_user_password):
        self._domain_user_password = domain_user_password

    @property
    def machine_object_ou(self):
        return self._machine_object_ou
    
    @machine_object_ou.setter
    def machine_object_ou(self, machine_object_ou):
        self._machine_object_ou = machine_object_ou

    @property
    def admin_password_enabled(self):
        return self._admin_password_enabled
    
    @admin_password_enabled.setter
    def admin_password_enabled(self, admin_password_enabled):
        self._admin_password_enabled = admin_password_enabled

    @property
    def admin_password_auto(self):
        return self._admin_password_auto
    
    @admin_password_auto.setter
    def admin_password_auto(self, admin_password_auto):
        self._admin_password_auto = admin_password_auto

    @property
    def admin_password(self):
        return self._admin_password
    
    @admin_password.setter
    def admin_password(self, admin_password):
        self._admin_password = admin_password

    @property
    def admin_auto_logon_enabled(self):
        return self._admin_auto_logon_enabled
    
    @admin_auto_logon_enabled.setter
    def admin_auto_logon_enabled(self, admin_auto_logon_enabled):
        self._admin_auto_logon_enabled = admin_auto_logon_enabled

    @property
    def admin_auto_logon_count(self):
        return self._admin_auto_logon_count
    
    @admin_auto_logon_count.setter
    def admin_auto_logon_count(self, admin_auto_logon_count):
        self._admin_auto_logon_count = admin_auto_logon_count

    @property
    def reset_password_required(self):
        return self._reset_password_required
    
    @reset_password_required.setter
    def reset_password_required(self, reset_password_required):
        self._reset_password_required = reset_password_required

    @property
    def customization_script(self):
        return self._customization_script
    
    @customization_script.setter
    def customization_script(self, customization_script):
        self._customization_script = customization_script

    @property
    def computer_name(self):
        return self._computer_name
    
    @computer_name.setter
    def computer_name(self, computer_name):
        self._computer_name = computer_name

    @property
    def link(self):
        return self._link
    
    @link.setter
    def link(self, link):
        self._link = link

    @property
    def any(self):
        return self._any
    
    @any.setter
    def any(self, any):
        self._any = any

    @property
    def href(self):
        return self._href
    
    @href.setter
    def href(self, href):
        self._href = href

    @property
    def type(self):
        return self._type
    
    @type.setter
    def type(self, type):
        self._type = type


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GuestCustomizationSectionType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
