"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class GatewayNatRuleType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'interface': 'ReferenceType',
        'original_ip': 'str',
        'original_port': 'str',
        'translated_ip': 'str',
        'translated_port': 'str',
        'protocol': 'str',
        'icmp_sub_type': 'str'
    }

    attribute_map = {
        'interface': 'interface',
        'original_ip': 'originalIp',
        'original_port': 'originalPort',
        'translated_ip': 'translatedIp',
        'translated_port': 'translatedPort',
        'protocol': 'protocol',
        'icmp_sub_type': 'icmpSubType'
    }

    def __init__(self, interface=None,original_ip=None,original_port=None,translated_ip=None,translated_port=None,protocol=None,icmp_sub_type=None):
        self._interface = None
        self._original_ip = None
        self._original_port = None
        self._translated_ip = None
        self._translated_port = None
        self._protocol = None
        self._icmp_sub_type = None

        if interface is not None:
            self.interface = interface
        if original_ip is not None:
            self.original_ip = original_ip
        if original_port is not None:
            self.original_port = original_port
        if translated_ip is not None:
            self.translated_ip = translated_ip
        if translated_port is not None:
            self.translated_port = translated_port
        if protocol is not None:
            self.protocol = protocol
        if icmp_sub_type is not None:
            self.icmp_sub_type = icmp_sub_type

    @property
    def interface(self):
        return self._interface
    
    @interface.setter
    def interface(self, interface):
        self._interface = interface

    @property
    def original_ip(self):
        return self._original_ip
    
    @original_ip.setter
    def original_ip(self, original_ip):
        self._original_ip = original_ip

    @property
    def original_port(self):
        return self._original_port
    
    @original_port.setter
    def original_port(self, original_port):
        self._original_port = original_port

    @property
    def translated_ip(self):
        return self._translated_ip
    
    @translated_ip.setter
    def translated_ip(self, translated_ip):
        self._translated_ip = translated_ip

    @property
    def translated_port(self):
        return self._translated_port
    
    @translated_port.setter
    def translated_port(self, translated_port):
        self._translated_port = translated_port

    @property
    def protocol(self):
        return self._protocol
    
    @protocol.setter
    def protocol(self, protocol):
        self._protocol = protocol

    @property
    def icmp_sub_type(self):
        return self._icmp_sub_type
    
    @icmp_sub_type.setter
    def icmp_sub_type(self, icmp_sub_type):
        self._icmp_sub_type = icmp_sub_type


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GatewayNatRuleType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
