"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..v_cloud_extensible_type import VCloudExtensibleType


class VMWStorageProfileType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'mo_ref': 'str',
        'vim_object_type': 'str',
        'free_storage_mb': 'int',
        'total_storage_mb': 'int',
        'data_store_refs': 'VimObjectRefsType',
        'name': 'str'
    }

    attribute_map = {
        'mo_ref': 'moRef',
        'vim_object_type': 'vimObjectType',
        'free_storage_mb': 'freeStorageMb',
        'total_storage_mb': 'totalStorageMb',
        'data_store_refs': 'dataStoreRefs',
        'name': 'name'
    }

    def __init__(self, mo_ref=None,vim_object_type=None,free_storage_mb=None,total_storage_mb=None,data_store_refs=None,name=None):
        self._mo_ref = None
        self._vim_object_type = None
        self._free_storage_mb = None
        self._total_storage_mb = None
        self._data_store_refs = None
        self._name = None

        if mo_ref is not None:
            self.mo_ref = mo_ref
        if vim_object_type is not None:
            self.vim_object_type = vim_object_type
        if free_storage_mb is not None:
            self.free_storage_mb = free_storage_mb
        if total_storage_mb is not None:
            self.total_storage_mb = total_storage_mb
        if data_store_refs is not None:
            self.data_store_refs = data_store_refs
        if name is not None:
            self.name = name

    @property
    def mo_ref(self):
        return self._mo_ref
    
    @mo_ref.setter
    def mo_ref(self, mo_ref):
        self._mo_ref = mo_ref

    @property
    def vim_object_type(self):
        return self._vim_object_type
    
    @vim_object_type.setter
    def vim_object_type(self, vim_object_type):
        self._vim_object_type = vim_object_type

    @property
    def free_storage_mb(self):
        return self._free_storage_mb
    
    @free_storage_mb.setter
    def free_storage_mb(self, free_storage_mb):
        self._free_storage_mb = free_storage_mb

    @property
    def total_storage_mb(self):
        return self._total_storage_mb
    
    @total_storage_mb.setter
    def total_storage_mb(self, total_storage_mb):
        self._total_storage_mb = total_storage_mb

    @property
    def data_store_refs(self):
        return self._data_store_refs
    
    @data_store_refs.setter
    def data_store_refs(self, data_store_refs):
        self._data_store_refs = data_store_refs

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VMWStorageProfileType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
